//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindUrlCach.h
 * @brief		C^[lbgLbVnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindUrlCach_H_
#define INCG_IRIS_WXFindUrlCach_H_

//======================================================================
// include
#include "../base/WXHandle.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include <wininet.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! C^[lbgLbVnhNX
class CFindUrlCach : public CHandle
{
public:
	template<typename CHARTYPE_>
	struct CharSet
	{
		typedef CHARTYPE_	type;
		typedef CHARTYPE_	*ptr;

		typedef typename iml::type_select< (cpp0x::is_same<type, WCHAR>::value), INTERNET_CACHE_ENTRY_INFOW, INTERNET_CACHE_ENTRY_INFOA >::type XINTERNET_CACHE_ENTRY_INFO;
		typedef XINTERNET_CACHE_ENTRY_INFO	*LPXINTERNET_CACHE_ENTRY_INFO;
	};
public:
	// RXgN^
	CFindUrlCach(void);
	CFindUrlCach(HANDLE hCach);
	// fXgN^
	virtual ~CFindUrlCach(void);

public:

	// 
	virtual bool	Close(void);

public:
	template<typename CHARTYPE_>
	// LbV폜
	static BOOL	Delete(const CHARTYPE_* lpszUrlName);

public:
	// LbV
	template<typename CHARTYPE_>
	BOOL	FindFirst(const CHARTYPE_* lpszUrlSearchPattern, typename CharSet<CHARTYPE_>::LPXINTERNET_CACHE_ENTRY_INFO lpCacheEntry, LPDWORD lpdwBufferSize);
	// 
	template<typename TN>
	BOOL	FindNext(TN  lpCacheEntry, LPDWORD lpdwBufferSize);

public:
	// LbV
	template<typename CHARTYPE_>
	BOOL	FindFirstEx(const CHARTYPE_* lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
				, typename CharSet<CHARTYPE_>::LPXINTERNET_CACHE_ENTRY_INFO lpCacheEntry, LPDWORD lpdwBufferSize);
	// 
	template<typename TN>
	BOOL	FindNextEx(TN  lpCacheEntry, LPDWORD lpdwBufferSize);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
