//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboardViewer.cpp
 * @brief		Nbv{[hr[[NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXClipboardViewer_CPP_

//======================================================================
// include
#include "WXClipboardViewer.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CClipboardViewer::CClipboardViewer(void)
: m_hNextViewer(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CClipboardViewer::CClipboardViewer(HWND hWnd)
: m_hNextViewer(nullptr)
{
	Open(hWnd);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CClipboardViewer::~CClipboardViewer(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
void CClipboardViewer::Open(HWND hWnd)
{
	Close();
	m_hNextViewer = SetClipboardViewer(hWnd);
	Attach(hWnd);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboardViewer::Close(void)
{
	HWND hWnd = Detach();
	if( hWnd == nullptr ) return FALSE;
	ChangeClipboardChain(hWnd, m_hNextViewer);
	m_hNextViewer = nullptr;
	return TRUE;
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CClipboardViewer::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_DRAWCLIPBOARD:	// Nbv{[h̓eύXꂽ
		if( m_hNextViewer != nullptr ) ::SendMessage(m_hNextViewer, uMsg, wParam, lParam);
		OnDrawClipboard();
		break;
	case WM_CHANGECBCHAIN:
		if( m_hNextViewer == (HWND)wParam ) 
		{
			ChangeCbChain(m_hNextViewer, (HWND)lParam);
			m_hNextViewer = (HWND)lParam;
		}
		else if( m_hNextViewer != nullptr )
		{
			::SendMessage(m_hNextViewer, uMsg, wParam, lParam);
		}
		break;
	}
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
