//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFileTime.h
 * @brief		t@C^CNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFileTime_CPP_

//======================================================================
// include
#include "WXFileTime.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFileTime::CFileTime(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	ft	= t@C^C\
*//***********************************************************************/
CFileTime::CFileTime(const FILETIME& ft)
: m_FileTime(ft)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFileTime::~CFileTime(void)
{
}

/**********************************************************************//**
 *
 * localize
 *
 ----------------------------------------------------------------------
 * @param [in]	ft	= t@C^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::Loacalize(const FILETIME* ft)
{
	return FileTimeToLocalFileTime(ft, &m_FileTime);
}

/**********************************************************************//**
 *
 * nationalize
 *
 ----------------------------------------------------------------------
 * @param [in]	ft	= t@C^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::Nationalize(const FILETIME* ft)
{
	return LocalFileTimeToFileTime(ft, &m_FileTime);
}

/**********************************************************************//**
 *
 * system timeɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSysTime	= VXe^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::ToSystemTime(LPSYSTEMTIME lpSysTime)	const
{
	return FileTimeToSystemTime(&m_FileTime, lpSysTime);
}

/**********************************************************************//**
 *
 * system timeݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSysTime	= VXe^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::FromSystemTime(const LPSYSTEMTIME lpSysTime)
{
	return SystemTimeToFileTime(lpSysTime, &m_FileTime);
}

/**********************************************************************//**
 *
 * tm \̂ɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lptm	= ^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::ToTM(tm* lptm)	const
{
	IRIS_ASSERT( lptm != nullptr );
	SYSTEMTIME stm = {0};
	if( !ToSystemTime(&stm) ) return FALSE;
	lptm->tm_hour	= stm.wHour;
	lptm->tm_min	= stm.wMinute;
	lptm->tm_mday	= stm.wDay;
	lptm->tm_mon	= stm.wMonth;
	lptm->tm_sec	= stm.wSecond;
	lptm->tm_year	= stm.wYear - 1900;
	return TRUE;
}

/**********************************************************************//**
 *
 * tm \̂ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lptm	= ^C\
 * @return	
*//***********************************************************************/
BOOL CFileTime::FromTM(const tm* lptm)
{
	IRIS_ASSERT( lptm != nullptr );
	SYSTEMTIME stm = {0};
	stm.wHour	= static_cast<WORD>(lptm->tm_hour);
	stm.wMinute	= static_cast<WORD>(lptm->tm_min);
	stm.wDay	= static_cast<WORD>(lptm->tm_mday);
	stm.wMonth	= static_cast<WORD>(lptm->tm_mon);
	stm.wSecond	= static_cast<WORD>(lptm->tm_sec);
	stm.wYear	= static_cast<WORD>(lptm->tm_year + 1900);
	return FromSystemTime(&stm);
}


}	// end of namespace wx
}	// end of namespace iris

