//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVirtualMemory.h
 * @brief		znhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXVirtualMemory_H_
#define INCG_IRIS_WXVirtualMemory_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx 
{

//======================================================================
// decalre
class CVirtualMemory;

//======================================================================
// typedef
typedef CVirtualMemory	CVMem;	//!< znhNX

//======================================================================
// class
//! znhNX
class CVirtualMemory : public INonCopyable<CVirtualMemory>
{
private:
	LPVOID	m_pReserve;	// \̈
	SIZE_T	m_Size;		// \TCY
public:
	// RXgN^
	CVirtualMemory(void);
	// fXgN^
	virtual ~CVirtualMemory(void);
public:
	// y[W\
	bool	Reserve(LPVOID lpAddr, SIZE_T dwSize, DWORD dwProtect, DWORD dwTypeOpt=0);
	// R~bg
	LPVOID	Commit(SIZE_T dwSize, DWORD dwProtect, DWORD dwTypeOpt=0);
	// R~bg̈̉
	BOOL	Decommit(LPVOID lpAddr, SIZE_T dwSize);
	// 
	void	Free(void);
#if	!defined(IRIS_WIN32_WCE)
	// Lock
	BOOL	Lock(LPVOID lpAddr, SIZE_T dwSize);
	// Unlock
	BOOL	Unlock(LPVOID lpAddr, SIZE_T dwSize);
#endif

public:
	// ProtectύX
	BOOL	Protect(LPVOID lpAddr, SIZE_T dwSize, DWORD dwProtect, LPDWORD lpdwOld);
public:
	// Alloc
	LPVOID	Alloc(LPVOID lpAddr, SIZE_T dwSize, DWORD dwType, DWORD dwProtect);

public:
	// get
	LPVOID	GetAddr(void)			{ return m_pReserve; }
	SIZE_T	GetSize(void)	const	{ return m_Size; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
