//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviFrame.cpp
 * @brief		AviFrame t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMAviFrame_CPP_

//======================================================================
// include
#include "WXMMAviFrame.h"
#include "../os/modules/WXAvifil.h"

namespace iris {
namespace wx
{

//======================================================================
// static
const LPBITMAPINFOHEADER CMMAviFrame::BESTDISPLAYFMT = reinterpret_cast<LPBITMAPINFOHEADER>(AVIGETFRAMEF_BESTDISPLAYFMT);

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMAviFrame::CMMAviFrame(void)
: m_pFrame(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMAviFrame::~CMMAviFrame(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	pavi		= Xg[
 * @param [in]	lpbiWanted	= vrbg}bvtH[}bg
 * @return	
*//***********************************************************************/
bool CMMAviFrame::Open(PAVISTREAM pavi, LPBITMAPINFOHEADER lpbiWanted)
{
	Close();
	m_pFrame = CAvifil::AVIStreamGetFrameOpen(pavi, lpbiWanted);
	return IsOpen();
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CMMAviFrame::IsOpen(void) const
{
	return m_pFrame != nullptr;
}

/**********************************************************************//**
 *
 * t@C
 * 
*//***********************************************************************/
void CMMAviFrame::Close(void)
{
	if( m_pFrame != nullptr )
	{
		CAvifil::AVIStreamGetFrameClose(m_pFrame);
		m_pFrame = nullptr;
	}
}

/**********************************************************************//**
 *
 * f[^̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lPos	= ʒu
 * @return	f[^̃AhX
*//***********************************************************************/
LPBITMAPINFOHEADER CMMAviFrame::GetFrameData(s32 lPos) const
{
	return static_cast<LPBITMAPINFOHEADER>(CAvifil::AVIStreamGetFrame(m_pFrame, lPos));
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "graphics/gl/GXGLSystem.h"
#include "graphics/gl/GXGLTexture.h"
#include "graphics/gl/GXGLError.h"
#include "WXMMAviFile.h"
#include "iris_tchar.h"
#include "iris_using.h"

//======================================================================
// declare
static void displayFunc1(void);

//======================================================================
// class
class CWXMMAviFrameTest : public iris::unit::CUnitTest<CWXMMAviFrameTest>
{
public:
	CGLTexture	m_tex;
};

//======================================================================
// test
IRIS_UNITTEST_F(CWXMMAviFrameTest, Avi)
{
	COpenGL& gl = COpenGL::GetInstance();
	CGLTexture& tex = m_tex;
	CMMAviFile file;
	CMMAviStream stream;
	CMMAviFrame frame;

	TCHAR path[MAX_PATH];
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::tcin >> path;
#endif

	if( !file.Open(path, OF_READ) )
	{
		_tprintf(path);
		_tprintf(IRIS_TEXT("\n"));
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}
	if( !stream.Open(file, CMMAviStream::VIDEO, 0) ) 
	{
		_tprintf(path);
		_tprintf(IRIS_TEXT("\n"));
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}
	std::cout << "file open" << std::endl;

	AVISTREAMINFO asi;
	if( !stream.GetInfo(&asi, sizeof(asi)) ) return;

	BITMAPINFOHEADER want;
	ZeroMemory(&want, sizeof(want));

	want.biSize = sizeof(BITMAPINFOHEADER);
	want.biBitCount = 24;
	want.biPlanes = 1;
	want.biWidth = asi.rcFrame.right - asi.rcFrame.left;
	want.biHeight = asi.rcFrame.bottom - asi.rcFrame.top;
	want.biCompression = BI_RGB;
	//if( !frame.Open(stream, CMMAviFrame::BESTDISPLAYFMT) )
	if( !frame.Open(stream, &want) )
	{
		return;
	}

	LPBITMAPINFOHEADER pbih = frame.GetFrameData(0);
	if( pbih == nullptr ) return;

	static const u32 buf_size = 4*1024*1024;	// 4KB
	void* buf = new u8 [buf_size];
	gx::gl::COpenGL::INIT_PARAM param;
	param.x = 100;
	param.y = 100;
	param.width = pbih->biWidth;
	param.height = pbih->biHeight;

	gl.Initialize(&param);
	gl.SetDisplayListBuffer(buf, buf_size);

	gl.ClearColor(0xFFFF2222);

	{
		if( !tex.Create() ) return;
		tex.Bind();
        tex.Parameteri(GL_TEXTURE_MAG_FILTER, GL_NEAREST);
        tex.Parameteri(GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		GXGL_ERROR(gl.GetError());
		tex.Image2D(0, 4, 512, 512, 0
			, GL_RGBA, GL_UNSIGNED_BYTE, nullptr);
		tex.SubImage2D(0, 0, 0, param.width, param.height
			, GL_RGBA, GL_UNSIGNED_BYTE, pbih+1);
		GXGL_ERROR(gl.GetError());
	}

	gxglutSetWindowTitle("CWXMMAviFrameTest");

    gxglutDisplayFunc( displayFunc1 );

#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
	gxglutDestroyWindow(gxglutGetWindow());
#else
	gxglutMainLoop();
#endif

	delete [] buf;
}

void displayFunc1(void)
{
	CWXMMAviFrameTest* ut = CWXMMAviFrameTest::GetCurrent();
	COpenGL& gl = COpenGL::GetInstance();
	CGLTexture& tex = ut->m_tex;

	gl.Clear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);

	gl.Start();

	{
		// eNX`on
		gl.Enable(GL_TEXTURE_2D);
		gl.Enable(GL_ALPHA_TEST);

		tex.Draw2D();

		// eNX`off
		gl.Disable(GL_TEXTURE_2D);
	}

	gl.Finish();

	gl.SwapBuffers();
}

#endif
