//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviStream.h
 * @brief		AviStream t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMAviStream_H_
#define INCG_IRIS_WXMMAviStream_H_

//======================================================================
// include
#include "WXMMVfw.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	AVI Xg[NX
*/
class CMMAviStream : public INonCopyable<CMMAviStream>
{
	friend class CMMAviFile;
	CMMVfw	m_Vfw;	//!< vfw IuWFNg

public:
	typedef enum StreamType
	{
		ALL		= 0,
		VIDEO	= streamtypeVIDEO,
		AUDIO	= streamtypeAUDIO,
		MIDI	= streamtypeMIDI,	
		TEXT	= streamtypeTEXT, 
	} StreamType;
protected:
	PAVISTREAM	m_pStream;	//!< Xg[

public:
	// RXgN^
	CMMAviStream(void);
	CMMAviStream(const CMMAviStream& rhs);
	// fXgN^
	virtual ~CMMAviStream(void);

public:
	// J
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* filename, DWORD fccType, LONG lParam, UINT uMode, LPCLSID lpHandler=nullptr);
	bool			Open(PAVIFILE pfile, DWORD fccType, LONG lParam);
	bool			IsValid(void) const;
	// 
	void			Close(void);

public:
	// 쐬
	bool			Create(UINT cfFormat, HANDLE hGlobal);

public:
	// fB[vRs[
	bool			Copy(const CMMAviStream& rhs, LPAVICOMPRESSOPTIONS lpOstions, LPCLSID lpHandler=nullptr);
	// V[Rs[
	void			Clone(const CMMAviStream& rhs);

public:
	// ̎擾
	template<typename FILEINFO_>
	bool			GetInfo(FILEINFO_* lpInfo, s32 lSize) const;

public:
	// f[^ǂݍ
	bool			Read(s32 lStart, s32 lSamples, LPVOID lpBuffer, s32 lSize, s32* lpReadBytes, s32* lpReadSamples) const;
	// tH[}bg̓ǂݍ
	bool			ReadFormat(s32 lStart, LPVOID lpFormat, s32* lpSize) const;

public:
	// Xg[̐擪Tv̔ԍ
	s32				GetStartSample(void) const;
	// ~bԂTvԍɕϊ
	s32				TimeToSample(s32 time) const;
	// Tvԍ~bԂɕϊ
	s32				SampleToTime(s32 sample) const;
	// Xg[̒擾
	s32				GetLength(void) const;

public:
	PAVISTREAM		GetStream(void) const	{ return m_pStream; }
	operator PAVISTREAM (void) const		{ return m_pStream; }
};

}	// end of namespace wx
}	// end of namespace iris


#endif
