//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviWav.cpp
 * @brief		AviWav t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMAviWav_CPP_

//======================================================================
// include
#include "WXMMAviWav.h"
#include "fnd/format/FndRIFF.h"
#include "../memory/WXGlobalMemory.h"
#include "../os/modules/WXAvifil.h"

namespace iris {
namespace wx
{


/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMAviWav::CMMAviWav(void)
: m_Start(0)
, m_Offset(0)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMAviWav::~CMMAviWav(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @return	
*//***********************************************************************/
bool CMMAviWav::OpenA(LPCSTR	filename)
{
	if( !CMMAviStream::Open(filename, AUDIO, 0, OF_READ| OF_SHARE_DENY_NONE) ) return false;
	return Init();
}
bool CMMAviWav::OpenW(LPCWSTR	filename)
{
	if( !CMMAviStream::Open(filename, AUDIO, 0, OF_READ| OF_SHARE_DENY_NONE) ) return false;
	return Init();
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CMMAviWav::IsOpen(void) const
{
	return CMMAviStream::IsValid();
}

/**********************************************************************//**
 *
 * t@C
 * 
*//***********************************************************************/
void CMMAviWav::Close(void)
{
	CMMAviStream::Close();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMMAviWav::Init(void)
{
	s32 lPos = GetStartSample();
	s32 rawFormatSize = 0;
	if( !ReadFormat(lPos, nullptr, &rawFormatSize) ) return false;
	u8* lpwf = new u8 [rawFormatSize];
	if( !ReadFormat(lPos, lpwf, &rawFormatSize) ) 
	{
		delete [] lpwf;
		return false;
	}
	m_WaveFmt = *pointer_cast<LPWAVEFORMATEX>(lpwf);
	delete [] lpwf;

	s32 lSamples = GetLength();
	if( lSamples == 0 ) return false;

	if( m_WaveFmt.wFormatTag != WAVE_FORMAT_PCM )
	{
		s32 length = 0;
		if( !Read(lPos, lSamples, nullptr, 0, &length, nullptr) )
			length = lSamples * m_WaveFmt.nBlockAlign;

		AVICOMPRESSOPTIONS opt;
		memset(&opt,0,sizeof(AVICOMPRESSOPTIONS));
		opt.fccType=CMMAviWav::AUDIO;
		opt.lpFormat=&m_WaveFmt;
		opt.cbFormat=sizeof(WAVEFORMATEX)-sizeof(WORD);

		SIZE_T bufsize = rawFormatSize + length + sizeof(fnd::RIFF_FILE_CHUNK) + sizeof(fnd::RIFF_CHUNK_HEADER) * 2;
		CMMAviStream clipboard;
		{
			CGlobalMemory gmem;
			if( !gmem.Alloc(GMEM_MOVEABLE, bufsize) ) return false;

			{
				CGlobalMemory::CScope buf(gmem);
				u8* p = static_cast<u8*>(buf);
				if( p == nullptr ) return false;

				if( !ReadFormat(lPos, p + sizeof(fnd::RIFF_FILE_CHUNK) + sizeof(fnd::RIFF_CHUNK_HEADER), &rawFormatSize) ) return false;
				if( !Read(lPos, lSamples, p + rawFormatSize + sizeof(fnd::RIFF_FILE_CHUNK) + sizeof(fnd::RIFF_CHUNK_HEADER) * 2
					, length, &length, nullptr ) ) return false;

				Close();

				{
					fnd::LPRIFF_FILE_CHUNK chunk = pointer_cast<fnd::LPRIFF_FILE_CHUNK>(p);
					chunk->uID		= fnd::RIFF_ID_FILE_CHUNK;
					chunk->Size		= rawFormatSize + length + sizeof(fnd::RIFF_FILE_CHUNK) + sizeof(fnd::RIFF_CHUNK_HEADER);
					chunk->uForm	= fnd::RIFF_FORM_WAVE;
					p += sizeof(fnd::RIFF_FILE_CHUNK);
				}
				{
					fnd::LPRIFF_CHUNK_HEADER chunk = pointer_cast<fnd::LPRIFF_CHUNK_HEADER>(p);
					chunk->uID		= fnd::RIFF_ID_FMT_CHUNK;
					chunk->Size		= rawFormatSize;
					p += sizeof(fnd::RIFF_CHUNK_HEADER) + rawFormatSize;
				}
				{
					fnd::LPRIFF_CHUNK_HEADER chunk = pointer_cast<fnd::LPRIFF_CHUNK_HEADER>(p);
					chunk->uID		= fnd::RIFF_ID_DATA_CHUNK;
					chunk->Size		= length;
				}
			}

			clipboard.Create(CF_WAVE, gmem);
		}

		m_WaveFmt.cbSize = sizeof(m_WaveFmt);
		m_WaveFmt.wFormatTag = WAVE_FORMAT_PCM;
		m_WaveFmt.wBitsPerSample	= m_WaveFmt.wBitsPerSample <= 12 ? 8u : 16u;
		m_WaveFmt.nBlockAlign		= m_WaveFmt.nChannels * m_WaveFmt.wBitsPerSample / 8;
		m_WaveFmt.nAvgBytesPerSec	= m_WaveFmt.nSamplesPerSec * m_WaveFmt.nBlockAlign;

		if( !Copy(clipboard, &opt, nullptr) ) return false;
		lPos = GetStartSample();
		lSamples = GetLength();
	}

	m_Size = lSamples;
	m_Start = m_Offset = lPos;
	return true;
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@
 * @return	WJobt@TCY
*//***********************************************************************/
u32 CMMAviWav::ReadPCM(void* lpBuffer, u32 length)
{
	if( !IsValid() ) return 0;

	s32 read = 0, read_samples = 0;
	s32 samples = length / m_WaveFmt.nBlockAlign;
	if( !Read(m_Offset, samples, lpBuffer, length, &read, &read_samples) ) return 0;
	m_Offset += read_samples;
	return read;
}

/**********************************************************************//**
 *
 * PCM obt@TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	PCM obt@TCY
*//***********************************************************************/
u32 CMMAviWav::GetSizePCM(void)	const
{
	return m_Size * m_WaveFmt.nBlockAlign;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CMMAviWav::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	*pwfex = m_WaveFmt;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CMMAviWav::Tell(void)	const
{
	return m_Offset-m_Start;
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CMMAviWav::TellTime(void)	const
{
	return SampleToTime(Tell()) / 1000.0;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	pos	= TvP
 * @return	
*//***********************************************************************/
bool CMMAviWav::Seek(s32 samples)
{
	m_Offset = samples + m_Start;
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CMMAviWav::SeekTime(f64 time)
{
	s32 millisec = static_cast<s32>(time * 1000);
	m_Offset = TimeToSample(millisec);
	return true;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "WXMMWaveOut.h"
#include "audio/format/AXAudioBuffer.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMMAviWavTest, Func)
{
	MMRESULT	mmr = MMSYSERR_NOERROR;//G[擾p
	CMMAviWav	wave;
	CMMWaveOut	waveOut;
	CAXBuffer<>	buffer(&wave);

	CHAR fname[MAX_PATH] = "../../data/snd/sample.avi";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "t@CpX͂ĂB" << std::endl;
	std::cin >> fname;
#endif
	if( !wave.Open( fname ) )
	{
		puts("avi file open failed.");
		return;
	}
	if( !buffer.Read() )
	{
		return;
	}

	// WAVEt@CI[v
	mmr = waveOut.Open(	wave.GetWaveFormatEx() );
	// G[
	if( mmr != MMSYSERR_NOERROR )
	{
		return;
	}

	// Đ
	waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
	waveOut.Write();

	WAVEFORMATEX *pWfx = wave.GetWaveFormatEx();

	{
		printf( "sample.wav̏\n" );

		printf( "FormatTag[%d]\n"		, pWfx->wFormatTag );
		printf( "Channels[%d]\n"		, pWfx->nChannels );
		printf( "SamplesPerSec[%d]\n"	, pWfx->nSamplesPerSec );
		printf( "AvgBytesPerSec[%d]\n"	, pWfx->nAvgBytesPerSec );
		printf( "BlockAlign[%d]\n"		, pWfx->nBlockAlign );
		printf( "BitsPerSample[%d]\n"	, pWfx->wBitsPerSample );
		printf( "Size[%d]\n"			, pWfx->cbSize );

		printf( "\n" );
		printf( "--------------------" );
		printf( "[ESCAPE] Close\n" );
		printf( "[Z]      Play\n" );
		printf( "[X]      Pause\n" );
		printf( "[C]      Loop Change\n" );
	}

	bool	bLoop		= true;		// [vtO
	bool	bPause		= false;	// |[YtO
	bool	bWaveLoop	= true;		// [vtO
	MMTIME	mmt			= {0};		// MMTIME\
	DWORD	dwSecond	= 0;

	mmt.wType = TIME_BYTES;

	while( bLoop )
	{
		waveOut.GetPosition(&mmt);
		// ĐԂ߂
		dwSecond = mmt.u.cb / pWfx->nAvgBytesPerSec;

		if( bWaveLoop == true )
		{
			if( mmt.u.cb >= wave.GetSizePCM() )
			{
				waveOut.Reset();
				waveOut.UnprepareHeader();
				waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
				waveOut.Write();
			}
		}
		// I
		if( GetAsyncKeyState( VK_ESCAPE ) & 0x8000 )
			bLoop = false;
		// Đ
		if( GetAsyncKeyState( 'Z' ) & 0x8000 )
		{
			waveOut.Reset();
			waveOut.UnprepareHeader();
			waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
			waveOut.Write();
			Sleep( 100 );
		}

		// |[Y
		if( GetAsyncKeyState( 'X' ) & 0x8000 )
		{
			if( bPause == false )
			{
				waveOut.Pause();
				bPause = true;
				Sleep( 100 );
			}
			else
			{
				waveOut.Restart();
				bPause = false;
				Sleep( 100 );
			}
		}

		// [v؂ւ
		if( GetAsyncKeyState( 'C' ) & 0x8000 )
		{
			if( bWaveLoop == false )
			{
				bWaveLoop = true;
				Sleep( 100 );
			}
			else
			{
				bWaveLoop = false;
				Sleep( 100 );
			}
		}
	}

	// WAVEt@C
	waveOut.Reset();
	waveOut.UnprepareHeader();
	waveOut.Close();
	wave.Close();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

