//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMVfw.cpp
 * @brief		Video for Windows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMVfw_CPP_

//======================================================================
// include
#include "WXMMVfw.h"
#include "fnd/utility/FndRefCounter.h"
#include "../os/modules/WXVfw.h"
#include "../os/modules/WXAvifil.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @private
 * @internal
 * @brief	CMMVfw::NX
*/
class CMMVfw::CImpl : public fnd::CRefCounter
{
public:
	static CImpl*	GetInstance(void)	{ static CImpl inst; return &inst; }

public:
	CImpl(void)
	{
	}
	~CImpl(void)
	{
		CVfw::TermVFW();
	}

public:
	// 
	void	Initialize(void)
	{
		if( GetRef() == 0 )
		{
			CAvifil::AVIFileInit();
			//CVfw::InitVFW();
		}
		AddRef();
	}
	// I
	void	Terminate(void)
	{
		SubRef();
		if( GetRef() <= 0 )
		{
			CAvifil::AVIFileExit();
			//CVfw::TermVFW();
		}
	}

};

/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CMMVfw::CMMVfw(void)
: m_pImpl(nullptr)
{
	m_pImpl = CImpl::GetInstance();
	if( m_pImpl != nullptr ) m_pImpl->Initialize();
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CMMVfw::~CMMVfw(void)
{
	if( m_pImpl == nullptr ) return;
	m_pImpl->Terminate();
	m_pImpl = nullptr;
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMVfw::CMMVfw(const CMMVfw& rObject)
: m_pImpl(rObject.m_pImpl)
{
	if( m_pImpl != nullptr ) 
	{
		m_pImpl->Initialize();
	}
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
CMMVfw& CMMVfw::operator = (CMMVfw& rObject)
{
	m_pImpl = rObject.m_pImpl;
	if( m_pImpl != nullptr ) m_pImpl->Initialize();
	return *this;
}

}	// end of namespace wx
}	// end of namespace iris

