//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMutex.h
 * @brief		mutexNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMutex_H_
#define INCG_IRIS_WXMutex_H_

//======================================================================
// include
#include "WXSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// mutexNX
class CMutex : public ISyncObject
{
public:
	// RXgN^
	CMutex(void);
	// RXgN^
	template<typename CHARTYPE_>
	CMutex(BOOL bInitiallyOwn, const CHARTYPE_* lpszName, SECURITY_ATTRIBUTES* psaAttribute)
	{
		Init(bInitiallyOwn, lpszName, psaAttribute);
	}
	// fXgN^
	~CMutex(void);
	
public:
	// 
	template<typename CHARTYPE_>
	BOOL	Init(BOOL bInitiallyOwn = FALSE, const CHARTYPE_* lpszName = nullptr, SECURITY_ATTRIBUTES* psaAttribute = nullptr);

public:
	// ̖OtmutexJ
#if	!defined(IRIS_WIN32_WCE)
	template<typename CHARTYPE_>
	BOOL	Open(DWORD dwDesiredAccess, BOOL bInheritHandle, const CHARTYPE_* lpName);
#endif

public:
    // AbN
    BOOL	Unlock(LONG lCount=0, LONG *pPrevCount = nullptr);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
