//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcess.h
 * @brief		vZXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXProcess_H_
#define INCG_IRIS_WXProcess_H_

//======================================================================
// include
#include "WXSyncObject.h"
#include "WXStartupInfo.h"
#include "../../../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// class
/// vZXNX
class CProcess : public ISyncObject
{
public:
	template<typename CHARTYPE_>
	struct CharSet
	{
		typedef CHARTYPE_	type;
		typedef CHARTYPE_	*ptr;

		typedef typename iml::type_select< (cpp0x::is_same<type, WCHAR>::value), STARTUPINFOW, STARTUPINFOA >::type XSTARTUPINFO;
#if	!defined(IRIS_WIN32_WCE) && IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
		typedef typename iml::type_select< (cpp0x::is_same<type, WCHAR>::value), STARTUPINFOEXW, STARTUPINFOEXA >::type XSTARTUPINFOEX;
#endif
	};
public:
	// RXgN^
	CProcess(void);
	CProcess(HANDLE hProcess);
	// fXgN^
	virtual ~CProcess(void);

public:
	// 쐬
	template<typename CHARTYPE_>
	BOOL	Create(const CHARTYPE_* lpApplicationName, CHARTYPE_* lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, const CHARTYPE_* lpCurrentDirectory
					   , typename CharSet<CHARTYPE_>::XSTARTUPINFO* lpStartupInfo, LPPROCESS_INFORMATION lppi);

#if	!defined(IRIS_WIN32_WCE)
	template<typename CHARTYPE_>
	BOOL	CreateAsUser(HANDLE hToken, const CHARTYPE_* lpApplicationName, CHARTYPE_* lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, const CHARTYPE_* lpCurrentDirectory
					   , typename CharSet<CHARTYPE_>::XSTARTUPINFO* lpStartupInfo, LPPROCESS_INFORMATION lppi);
#endif

	// N܂őҋ@
	void	WaitWakeup(void);
	// vZXI
	void	Destroy(DWORD dwTimeout=1000);
	// vZX̋I
	BOOL	Terminate(UINT uExitCode);
	// IĂ邩ǂ
	BOOL	IsExit(void) const;
	// NďI҂
	template<typename CHARTYPE_>
	DWORD	RunWait(const CHARTYPE_* lpApplicationName, CHARTYPE_* lpCmdLine
		, LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
		, BOOL bInheritHandles, DWORD dwCreationFlags
		, LPVOID lpEnvironment, const CHARTYPE_* lpCurrentDirectory
		, typename CharSet<CHARTYPE_>::XSTARTUPINFO* lpStartupInfo);

public:

	// vZX̏IR[h̎擾
	DWORD	GetExitCode(void) const;
#if	!defined(IRIS_WIN32_WCE)
	// vZXID̎擾
	DWORD	GetProcessId(void) const;
	// vZX̎ԏ擾
	BOOL	GetProcessTimes(LPFILETIME lpCreationTime, LPFILETIME lpExitTime, LPFILETIME lpKernelTime, LPFILETIME lpUserTime) const;
	// vZX̃J[l[hł̌oߎԂ擾
	BOOL	GetProcessKernelTime(LPFILETIME lpKernelTime) const;
#endif

public:
	// vZXJ
	BOOL	Open(DWORD dwProcessId, DWORD dwDesiredAccess=PROCESS_ALL_ACCESS, BOOL bInheritHandleE=TRUE);

private:
	// 쐬ʏ
	BOOL	_Create(LPPROCESS_INFORMATION lppid, LPPROCESS_INFORMATION lppis);
};

/// vZXNX
class CProcessInfo : public INonCopyable<>
{
protected:
	PROCESS_INFORMATION	m_Info;	//!< vZX
public:
	// fXgN^
	virtual ~CProcessInfo(void);
public:
	/// vZX̎擾
			PROCESS_INFORMATION&	GetProcessInfo(void)		{ return m_Info; }
	const	PROCESS_INFORMATION&	GetProcessInfo(void) const	{ return m_Info; }
			PROCESS_INFORMATION*	operator () (void)			{ return &m_Info; }
	const	PROCESS_INFORMATION*	operator () (void)	const	{ return &m_Info; }
	operator 		PROCESS_INFORMATION*	(void)				{ return &m_Info; }
	operator const	PROCESS_INFORMATION*	(void)	const		{ return &m_Info; }

	PROCESS_INFORMATION* operator -> (void)	{ return &m_Info; }

public:
	// nh
	void	Close(void);

public:
	// vZXI
	void	Exit(void);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
