//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStartupInfo.h
 * @brief		StartupInfo t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStartupInfo_H_
#define INCG_IRIS_WXStartupInfo_H_

//======================================================================
// include
#include "../../../../iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename SI>class CTStartupInfo;

//======================================================================
// typedef
typedef CTStartupInfo<STARTUPINFOA>	CStartupInfoA;
typedef CTStartupInfo<STARTUPINFOW>	CStartupInfoW;
typedef CTStartupInfo<STARTUPINFO>	CStartupInfo;

//======================================================================
// class
/// StartupNX
template<typename SI>
class CTStartupInfo : public IIrisObject
{
	typedef SI		value_type;
	typedef SI		*value_ptr;
	typedef SI		&value_ref;
public:
	value_type	m_si;
public:
	/// RXgN^
	CTStartupInfo(void);
public:
	/**
	 * @name operator
	 * @{
	*/
	operator		value_type* (void)			{ return &m_si; }
	operator const	value_type* (void)	const	{ return &m_si; }

	value_ref operator() (void)	{ return m_si; }
	/**
	 * @}
	*/

public:
	// g̃vZX擾
	void	GetSelf(void);
	// \ݒ
	void	Hide(void);
	// \ݒ
	void	Show(void);
	// Wo͂̐ݒ
	void	UseStdHandles(HANDLE hChildStdOut, HANDLE hChildStdIn, HANDLE hChildStdErr);
	// Wo͂̐ݒ
	void	UseStdHandles(void);
	/// XgA
	void	Restore(void);
};



}	// end of namespace wx
}	// end of namespace iris

#endif
