//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToken.cpp
 * @brief		g[NnhNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXToken_CPP_

//======================================================================
// include
#include "WXToken.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CToken::CToken(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CToken::~CToken(void)
{
}

/**********************************************************************//**
 *
 * vZXJ
 *
 -----------------------------------------------------------------------
 * @param [in]	hProcess		= vZXnh
 * @param [in]	dwDesiredAccess	= ]ANZX(TOKEN_QUERY***)
 * @return	
*//***********************************************************************/
BOOL CToken::OpenFromProcess(HANDLE hProcess, DWORD dwDesiredAccess)
{
	HANDLE hToken = nullptr;
	if( !::OpenProcessToken(hProcess, dwDesiredAccess, &hToken) ) return FALSE;
	return TryAttach(hToken);
}

/**********************************************************************//**
 *
 * XbhJ
 *
 -----------------------------------------------------------------------
 * @param [in]	hThread			= Xbhnh
 * @param [in]	dwDesiredAccess	= ]ANZX
 * @param [in]	bOpenAsSelf		= Xbh̃ZLeBɊւtO
 * @return	
*//***********************************************************************/
BOOL CToken::OpenFromThread(HANDLE hProcess, DWORD dwDesiredAccess, BOOL bOpenAsSelf)
{
	HANDLE hToken = nullptr;
	if( !::OpenThreadToken(hProcess, dwDesiredAccess, bOpenAsSelf, &hToken) ) return FALSE;
	return TryAttach(hToken);
}

/**********************************************************************//**
 *
 * 擾
 *
 -----------------------------------------------------------------------
 * @param [in]	TokenInformationClass	= 擾̎ށiToken***j
 * @param [out]	TokenInformation		= o̓obt@
 * @param [in]	TokenInformationLength	= o̓obt@TCY
 * @param [out]	ReturnLength			= o̓obt@ɕKvȃTCY
 * @return	
*//***********************************************************************/
BOOL CToken::GetInformation(TOKEN_INFORMATION_CLASS TokenInformationClass, LPVOID TokenInformation
		, DWORD TokenInformationLength, PDWORD ReturnLength) const
{
	return ::GetTokenInformation(m_hObject, TokenInformationClass, TokenInformation, TokenInformationLength, ReturnLength);
}

/**********************************************************************//**
 *
 * 擾
 *
 * @note	TOKEN_SOURCE ȊÓATOKEN_QUERY ANZXKv
 *			TOKEN_SOURCE ɂ́ATOKEN_QUERY_SOURCE ANZXKv
 *
 -----------------------------------------------------------------------
 * @param [out]	TokenInformation		= o̓obt@
 * @return	
*//***********************************************************************/
template<>
BOOL CToken::GetInformation<TOKEN_USER>(PTOKEN_USER TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenUser, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_GROUPS>(PTOKEN_GROUPS TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenGroups, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_PRIVILEGES>(PTOKEN_PRIVILEGES TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenPrivileges, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_OWNER>(PTOKEN_OWNER TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenOwner, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_PRIMARY_GROUP>(PTOKEN_PRIMARY_GROUP TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenPrimaryGroup, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_DEFAULT_DACL>(PTOKEN_DEFAULT_DACL TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenDefaultDacl, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_SOURCE>(PTOKEN_SOURCE TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenSource, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_TYPE>(PTOKEN_TYPE TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenType, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<SECURITY_IMPERSONATION_LEVEL>(PSECURITY_IMPERSONATION_LEVEL TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenImpersonationLevel, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_STATISTICS>(PTOKEN_STATISTICS TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenStatistics, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<DWORD>(LPDWORD TokenInformation) const
{
	DWORD dwReturn = 0;
	return GetInformation(TokenSessionId, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}
template<>
BOOL CToken::GetInformation<TOKEN_ELEVATION>(PTOKEN_ELEVATION TokenInformation) const
{
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
	DWORD dwReturn = 0;
	return GetInformation(TokenElevation, TokenInformation, sizeof(*TokenInformation), &dwReturn);
#else
	return FALSE;	// dll R[Ă킯Ȃ̂ŁA FALSE ԂB
#endif
}
template<>
BOOL CToken::GetInformation<TOKEN_ELEVATION_TYPE>(PTOKEN_ELEVATION_TYPE TokenInformation) const
{
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
	DWORD dwReturn = 0;
	return GetInformation(TokenElevationType, TokenInformation, sizeof(*TokenInformation), &dwReturn);
#else
	return FALSE;	// dll R[Ă킯Ȃ̂ŁA FALSE ԂB
#endif
}

/**********************************************************************//**
 *
 * 擾
 *
 * @note	TOKEN_SOURCE ȊÓATOKEN_QUERY ANZXKv
 *			TOKEN_SOURCE ɂ́ATOKEN_QUERY_SOURCE ANZXKv
 *
 -----------------------------------------------------------------------
 * @param [in]	TokenInformationClass	= 擾̎ށiToken***j
 * @param [out]	TokenInformation		= o̓obt@
 * @return	
*//***********************************************************************/
BOOL CToken::GetTokenGroup(TOKEN_INFORMATION_CLASS TokenInformationClass, PTOKEN_GROUPS TokenInformation) const
{
	IRIS_ASSERT( (TokenInformationClass == TokenGroups) || (TokenInformationClass == TokenRestrictedSids) );
	DWORD dwReturn = 0;
	return GetInformation(TokenInformationClass, TokenInformation, sizeof(*TokenInformation), &dwReturn);
}

/**********************************************************************//**
 *
 * OI
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszUsername		= [U[
 * @param [in]	lpszDomain			= hC܂̓T[o[
 * @param [in]	lpszPassword		= pX[h
 * @param [in]	dwLogonType			= OI^Cv
 * @param [in]	dwLogonProvider		= OIvoC_
 * @return	
*//***********************************************************************/
template<>
BOOL CToken::LogonUser<CHAR>(LPCSTR lpszUsername, LPCSTR lpszDomain, LPCSTR lpszPassword, DWORD dwLogonType, DWORD dwLogonProvider)
{
	HANDLE hToken = nullptr;
	if( !::LogonUserA(lpszUsername, lpszDomain, lpszPassword, dwLogonType, dwLogonProvider, &hToken) ) return FALSE;
	return TryAttach(hToken);
}
template<>
BOOL CToken::LogonUser<WCHAR>(LPCWSTR lpszUsername, LPCWSTR lpszDomain, LPCWSTR lpszPassword, DWORD dwLogonType, DWORD dwLogonProvider)
{
	HANDLE hToken = nullptr;
	if( !::LogonUserW(lpszUsername, lpszDomain, lpszPassword, dwLogonType, dwLogonProvider, &hToken) ) return FALSE;
	return TryAttach(hToken);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <string.h>

//======================================================================
// test
IRIS_UNITTEST(CWXTokenTest, ElevationType)
{
	CToken token;
	ASSERT_TRUE( token.OpenFromProcess(::GetCurrentProcess(), TOKEN_QUERY) );
	TOKEN_ELEVATION_TYPE type;
	ASSERT_TRUE( token.GetInformation(&type) );

	switch( type )
	{
	case TokenElevationTypeDefault:
		puts("TokenElevationTypeDefault");
		break;
	case TokenElevationTypeFull:
		puts("TokenElevationTypeFull");
		break;
	case TokenElevationTypeLimited:
		puts("TokenElevationTypeLimited");
		break;
	}
}

IRIS_UNITTEST(CWXTokenTest, Source)
{
	CToken token;
	ASSERT_TRUE( token.OpenFromProcess(::GetCurrentProcess(), TOKEN_QUERY_SOURCE) );
	TOKEN_SOURCE source;
	ASSERT_TRUE( token.GetInformation(&source) );

	std::cout << source.SourceName << std::endl;
}

#endif
