//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToken.h
 * @brief		g[NnhNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXToken_H_
#define INCG_IRIS_WXToken_H_

//======================================================================
// include
#include "WXSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// CxgNX
class CToken : public ISyncObject
{
public:
	// RXgN^
	CToken(void);
	// fXgN^
	~CToken(void);

public:
	// vZXJ
	BOOL	OpenFromProcess(HANDLE hProcess, DWORD dwDesiredAccess);
	// XbhJ
	BOOL	OpenFromThread(HANDLE hProcess, DWORD dwDesiredAccess, BOOL bOpenAsSelf);

public:
	// 擾
	BOOL	GetInformation(TOKEN_INFORMATION_CLASS TokenInformationClass, LPVOID TokenInformation
		, DWORD TokenInformationLength, PDWORD ReturnLength) const;
	template<typename TN>
	BOOL	GetInformation(TN* TokenInformation) const;
	// TokeGroup 擾
	BOOL	GetTokenGroup(TOKEN_INFORMATION_CLASS TokenInformationClass, PTOKEN_GROUPS TokenInformation) const;

public:
	// OC
	template<typename CHARTYPE_>
	BOOL	LogonUser(const CHARTYPE_* lpszUsername, const CHARTYPE_* lpszDomain, const CHARTYPE_* lpszPassword
		, DWORD dwLogonType, DWORD dwLogonProvider);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
