//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnvironmentStrings.cpp
 * @brief		EnvironmentStrings t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXEnvironmentStrings_CPP_

//======================================================================
// include
#include "WXEnvironmentStrings.h"

#if !defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
template<typename CHARTYPE_>
CTEnvironmentStrings<CHARTYPE_>::CTEnvironmentStrings(void)
: m_lpEnvStr(nullptr)
{
	Load();
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
template<typename CHARTYPE_>
CTEnvironmentStrings<CHARTYPE_>::~CTEnvironmentStrings(void)
{
	Unload();
}

/**********************************************************************//**
 *
 * ǂݍ
 * 
*//***********************************************************************/
template<>
BOOL CTEnvironmentStrings<CHAR>::Load(void)
{
	if( !Unload() ) return FALSE;
#if	defined(UNICODE) && defined(GetEnvironmentStrings)
#  undef GetEnvironmentStrings
#endif
	m_lpEnvStr = ::GetEnvironmentStrings();
	return TRUE;
}
template<>
BOOL CTEnvironmentStrings<WCHAR>::Load(void)
{
	if( !Unload() ) return FALSE;
	m_lpEnvStr = ::GetEnvironmentStringsW();
	return TRUE;
}


/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
template<>
BOOL CTEnvironmentStrings<CHAR>::Unload(void)
{
	if( m_lpEnvStr != nullptr )
	{
		if( !FreeEnvironmentStringsA(m_lpEnvStr) ) return FALSE;
		m_lpEnvStr = nullptr;
	}
	return TRUE;
}
template<>
BOOL CTEnvironmentStrings<WCHAR>::Unload(void)
{
	if( m_lpEnvStr != nullptr )
	{
		if( !FreeEnvironmentStringsW(m_lpEnvStr) ) return FALSE;
		m_lpEnvStr = nullptr;
	}
	return TRUE;
}

template class CTEnvironmentStrings<CHAR>;
template class CTEnvironmentStrings<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris


#endif
