//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMappedProfile.h
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMappedProfile_H_
#define INCG_IRIS_WXMappedProfile_H_

//======================================================================
// include
#include "WXPrivateProfile.h"
#include "stl/STLvecmap.h"
#include "stl/STLtstring.h"

namespace iris {
namespace wx 
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTMappedPrivateProfile;

//======================================================================
// typedef
typedef CTMappedPrivateProfile<CHAR>	CMappedPrivateProfileA;
typedef CTMappedPrivateProfile<WCHAR>	CMappedPrivateProfileW;
typedef CTMappedPrivateProfile<TCHAR>	CMappedPrivateProfile;

//======================================================================
// class
//! MappedPrivateProfileNX
template<typename CHARTYPE_>
class CTMappedPrivateProfile : public CTPrivateProfile<CHARTYPE_>
{
	typedef CTPrivateProfile<CHARTYPE_>				_Mybase;
	typedef CTMappedPrivateProfile<CHARTYPE_>		_Myt;
public:
	// 
	typedef std::basic_string<_Mychar>				_Mystring;
	typedef	_Mystring								KeyData;
	typedef std::pair<_Mystring, KeyData>			SectionPair;
	typedef stl::vecmap<_Mystring, KeyData>			SectionData;
	typedef std::pair<_Mystring, SectionData>		ProfilePair;
	typedef stl::vecmap<_Mystring, SectionData>		ProfileData;

private:
	// }bvf[^
	ProfileData	m_Profile;

public:
	// RXgN^
	CTMappedPrivateProfile(void);
	// fXgN^
	virtual ~CTMappedPrivateProfile(void);
public:
	// 
	virtual void	Close(void);

public:
	// ZNṼXg
	bool		MakeAppList(void);
	// L[̃Xg
	//	ŃZNṼXg܂
	bool		MakeKeyList(_Mylpcstr lpAppName);
	// L[̃Xg
	static bool	MakeKeyList(_Mylpcstr lpAppName, _Mylpcstr lpFileName, SectionData& rData);

public:
	// ZNVEL[̃Xg
	bool		MakeProfileList(void);
	// Xg̃NA
	void		ClearProfileList(void);
	// Xg
	bool		WriteList(bool bClear);

public:
	// set, get
	// vt@C̎擾
	ProfileData&		GetProfileData(void)			{ return m_Profile; }
	const ProfileData&	GetProfileData(void)	const	{ return m_Profile; }

	// ZNV̎擾
	_Mystring*		GetSectionName(int nIndex);
	// L[̎擾
	_Mystring*		GetKeyName(int nAppIndex, int nIndex);
	_Mystring*		GetKeyName(_Mylpcstr lpAppName, int nIndex);
	// L[l̎擾
	KeyData*		GetKeyData(int nAppIndex, int nKeyIndex);
	KeyData*		GetKeyData(_Mylpcstr lpAppName, int nKeyIndex);
	KeyData*		GetKeyData(_Mylpcstr lpAppName, _Mylpcstr lpKeyName);

	// ZNV폜
	BOOL			DeleteSection(_Mylpcstr lpAppName);
	// L[폜
	BOOL			DeleteKey(_Mylpcstr lpAppName, _Mylpcstr lpKeyName);

public:

	// L[Xǧ
	SectionData*	FindSectionData(_Mylpcstr lpAppName);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
