//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPrivateProfile.cpp
 * @brief		PrivateProfile NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPrivateProfile_CPP_

//======================================================================
// include
#include "WXPrivateProfile.h"
#include "iris_debug.h"
#include "iris_xchar.hpp"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "%d", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileIntA Q
BOOL WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"%d", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@Cɐl(HEX)
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "0x%x", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileHexA Q
BOOL WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"0x%x", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C琮l(HEX)擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= ftHgl
 * @param [in]	lpFileName	= t@C
 * @return	l
*//***********************************************************************/
DWORD GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName)
{
	CHAR val[128], def[128];
	wsprintfA(def, "%x", nDefault);
	DWORD size = GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	if( size == 0 ) return nDefault;
	LPSTR p = nullptr;
#if 0
	DWORD ret = reinterpret_cast<DWORD>(strtol(val, &p, 16));
	if( ret == LONG_MAX )
	{
		if( errno == ERANGE )
		{
			ret = strtoul(val, &p, 16);
		}
	}
#else
	DWORD ret = strtoul(val, &p, 16);
#endif
	if( ret == 0 && p == val ) return nDefault;
	return ret;
}
/// iris::wx::GetPrivateProfileHexA Q
DWORD GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName)
{
	WCHAR val[128], def[128];
	wsprintfW(def, L"%x", nDefault);
	DWORD size = GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	if( size == 0 ) return nDefault;
	LPWSTR p = nullptr;
#if 0
	DWORD ret = reinterpret_cast<DWORD>(wcstol(val, &p, 16));
	if( ret == LONG_MAX )
	{
		if( errno == ERANGE )
		{
			ret = wcstol(val, &p, 16);
		}
	}
#else
	DWORD ret = wcstoul(val, &p, 16);
#endif
	if( ret == 0 && p == val ) return nDefault;
	return ret;
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	sprintf_s(val, 128, "%f", fValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileFloatA Q
BOOL WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	swprintf_s(val, 128, L"%f", fValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @param [in]	lpFileName	= t@C
 * @return	l
*//***********************************************************************/
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName)
{
	CHAR val[128], def[128];
	sprintf_s(def, 128, "%f", fDefault);
	GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	float ret = (float)atof(val);
	return ret;
}
/// iris::wx::GetPrivateProfileFloatA Q
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName)
{
	WCHAR val[128], def[128];
	swprintf_s(def, 128, L"%f", fDefault);
	GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	float ret = (float)_wtof(val);
	return ret;
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}
/// iris::wx::WritePrivateProfileWindowPlacementA Q
BOOL WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName)
{
	return GetPrivateProfileStructA(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName)
{
	return GetPrivateProfileStructW(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTPrivateProfile<CHARTYPE_>::CTPrivateProfile(void)
{
	m_Path[0] = 0;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTPrivateProfile<CHARTYPE_>::~CTPrivateProfile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
template<typename CHARTYPE_>
void CTPrivateProfile<CHARTYPE_>::Open(_Mylpcstr path)
{
	Close();
	xcscpy_s(m_Path, MAX_PATH, path);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTPrivateProfile<CHARTYPE_>::Close(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * ݂ZNV擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<>
DWORD CTPrivateProfile<CHAR>::GetSectionNames(_Mylpstr lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileSectionNamesA(lpReturn, nSize, m_Path);
}
template<>
DWORD CTPrivateProfile<WCHAR>::GetSectionNames(_Mylpstr lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileSectionNamesW(lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * ZNVɑ݂L[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
DWORD CTPrivateProfile<CHARTYPE_>::GetSection(_Mylpcstr lpAppName, _Mylpstr lpReturn, DWORD nSize)	const
{
	return GetSection(lpAppName, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C當擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpDefault	= sƂɕԂ
 * @param [out]	lpReturn	= o̓obt@(L['='؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<>
DWORD CTPrivateProfile<CHAR>::GetString(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpDefault, _Mylpstr lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileStringA(lpAppName, lpKeyName, lpDefault, lpReturn, nSize, m_Path);
}
template<>
DWORD CTPrivateProfile<WCHAR>::GetString(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpDefault, _Mylpstr lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileStringW(lpAppName, lpKeyName, lpDefault, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C琮l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
template<>
UINT CTPrivateProfile<CHAR>::GetInt(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, INT nDefault)	const
{
	return GetPrivateProfileIntA(lpAppName, lpKeyName, nDefault, m_Path);
}
template<>
UINT CTPrivateProfile<WCHAR>::GetInt(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, INT nDefault)	const
{
	return GetPrivateProfileIntW(lpAppName, lpKeyName, nDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@CHEXl擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	HEXl
*//***********************************************************************/
template<>
DWORD CTPrivateProfile<CHAR>::GetHex(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwDefault)	const
{
	return GetPrivateProfileHexA(lpAppName, lpKeyName, dwDefault, m_Path);
}
template<>
DWORD CTPrivateProfile<WCHAR>::GetHex(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwDefault)	const
{
	return GetPrivateProfileHexW(lpAppName, lpKeyName, dwDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
template<>
float CTPrivateProfile<CHAR>::GetFloat(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fDefault)	const
{
	return GetPrivateProfileFloatA(lpAppName, lpKeyName, fDefault, m_Path);
}
template<>
float CTPrivateProfile<WCHAR>::GetFloat(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fDefault)	const
{
	return GetPrivateProfileFloatW(lpAppName, lpKeyName, fDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C\̂擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [out]	lpStruct	= o̓obt@
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::GetStruct(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize)	const
{
	return GetPrivateProfileStructA(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::GetStruct(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize)	const
{
	return GetPrivateProfileStructW(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o̓obt@(WINDOWPLACEMENT)
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPWINDOWPLACEMENT lpwdpl)	const
{
	return GetPrivateProfileWindowPlacementA(lpAppName, lpKeyName, lpwdpl, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPWINDOWPLACEMENT lpwdpl)	const
{
	return GetPrivateProfileWindowPlacementW(lpAppName, lpKeyName, lpwdpl, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd)	const
{
	return GetPrivateProfileWindowPlacementA(lpAppName, lpKeyName, hWnd, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd)	const
{
	return GetPrivateProfileWindowPlacementW(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * t@CɃL[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpString	= L[
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteSection(_Mylpcstr lpAppName, _Mylpcstr lpString)
{
	return WritePrivateProfileSectionA(lpAppName, lpString, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteSection(_Mylpcstr lpAppName, _Mylpcstr lpString)
{
	return WritePrivateProfileSectionW(lpAppName, lpString, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteInt(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, UINT nValue)
{
	return WritePrivateProfileIntA(lpAppName, lpKeyName, nValue, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteInt(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, UINT nValue)
{
	return WritePrivateProfileIntW(lpAppName, lpKeyName, nValue, m_Path);
}

/**********************************************************************//**
 *
 * t@CHEXl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	dwValue		= L[l
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteHex(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwValue)
{
	return WritePrivateProfileHexA(lpAppName, lpKeyName, dwValue, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteHex(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwValue)
{
	return WritePrivateProfileHexW(lpAppName, lpKeyName, dwValue, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteFloat(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fValue)
{
	return WritePrivateProfileFloatA(lpAppName, lpKeyName, fValue, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteFloat(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fValue)
{
	return WritePrivateProfileFloatW(lpAppName, lpKeyName, fValue, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɕ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpString	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteString(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpString)
{
	return WritePrivateProfileStringA(lpAppName, lpKeyName, lpString, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteString(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpString)
{
	return WritePrivateProfileStringW(lpAppName, lpKeyName, lpString, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɍ\̂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpStruct	= \̃|C^
 * @param [in]	nSize		= \̃TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteStruct(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize)
{
	return WritePrivateProfileStructA(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteStruct(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize)
{
	return WritePrivateProfileStructW(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= WINDOWPLACEMENT̎擾EBhEnh
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::WriteWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd)
{
	return WritePrivateProfileWindowPlacementA(lpAppName, lpKeyName, hWnd, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::WriteWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd)
{
	return WritePrivateProfileWindowPlacementW(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * t@CL[폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::RemoveKey(_Mylpcstr lpAppName, _Mylpcstr lpKeyName)
{
	return WritePrivateProfileStringA(lpAppName, lpKeyName, nullptr, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::RemoveKey(_Mylpcstr lpAppName, _Mylpcstr lpKeyName)
{
	return WritePrivateProfileStringW(lpAppName, lpKeyName, nullptr, m_Path);
}

/**********************************************************************//**
 *
 * t@CZNV폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::RemoveSection(_Mylpcstr lpAppName)
{
	return WritePrivateProfileStringA(lpAppName, nullptr, nullptr, m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::RemoveSection(_Mylpcstr lpAppName)
{
	return WritePrivateProfileStringW(lpAppName, nullptr, nullptr, m_Path);
}

/**********************************************************************//**
 *
 * t@C폜
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPrivateProfile<CHAR>::Remove(void)
{
	return DeleteFileA(m_Path);
}
template<>
BOOL CTPrivateProfile<WCHAR>::Remove(void)
{
	return DeleteFileW(m_Path);
}


/**********************************************************************//**
 *
 * 󂩂ǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTPrivateProfile<CHARTYPE_>::IsEmpty(void) const
{
	IRIS_ASSERT( IsOpen() );
	_Mychar tmp[256];
	return (GetSectionNames(tmp, 256) == 0);
}

/**********************************************************************//**
 *
 * ZNVɑ݂L[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @param [in]	lpszPath	= t@C
 * @return	
*//***********************************************************************/
template<>
DWORD CTPrivateProfile<CHAR>::GetSection(_Mylpcstr lpAppName, _Mylpstr lpReturn, DWORD nSize, _Mylpcstr lpszPath)
{
	return GetPrivateProfileSectionA(lpAppName, lpReturn, nSize, lpszPath);
}
template<>
DWORD CTPrivateProfile<WCHAR>::GetSection(_Mylpcstr lpAppName, _Mylpstr lpReturn, DWORD nSize, _Mylpcstr lpszPath)
{
	return GetPrivateProfileSectionW(lpAppName, lpReturn, nSize, lpszPath);
}

template class CTPrivateProfile<CHAR>;
template class CTPrivateProfile<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
