//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPrivateProfile.h
 * @brief		PrivateProfile NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPrivateProfile_H_
#define INCG_IRIS_WXPrivateProfile_H_

//======================================================================
// include
#include "stl/STLvecmap.h"
#include "stl/STLtstring.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx 
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTPrivateProfile;

//======================================================================
// typedef
typedef CTPrivateProfile<CHAR>	CPrivateProfileA;
typedef CTPrivateProfile<WCHAR>	CPrivateProfileW;
typedef CTPrivateProfile<TCHAR>	CPrivateProfile;

//======================================================================
// function
// l̏
BOOL	WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName);
// l(HEX)̏
BOOL	WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName);
// l(HEX)̎擾
DWORD	GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName);
DWORD	GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName);
// l̏
BOOL	WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName);
// l̎擾
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName);
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName);
// WINDOWPLACEMENT̏
BOOL	WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);
// WINDOWPLACEMENT̎擾
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName);
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);

//======================================================================
// define
#ifdef UNICODE
#  define WritePrivateProfileInt				WritePrivateProfileIntW
#  define WritePrivateProfileHex				WritePrivateProfileHexW
#  define WritePrivateProfileFloat				WritePrivateProfileFloatW
#  define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementW
#  define GetPrivateProfileHex					GetPrivateProfileHexW
#  define GetPrivateProfileFloat				GetPrivateProfileFloatW
#  define GetPrivateProfileWindowPlacement		GetPrivateProfileWindowPlacementW
#else
#  define WritePrivateProfileInt				WritePrivateProfileIntA
#  define WritePrivateProfileHex				WritePrivateProfileHexA
#  define WritePrivateProfileFloat				WritePrivateProfileFloatA
#  define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementA
#  define GetPrivateProfileHex					GetPrivateProfileHexA
#  define GetPrivateProfileFloat				GetPrivateProfileFloatA
#  define GetPrivateProfileWindowPlacement		GetPrivateProfileWindowPlacementA
#endif

//======================================================================
// class
//! PrivateProfileNX
template<typename CHARTYPE_>
class CTPrivateProfile : public IIrisObject
{
	typedef CTPrivateProfile<CHARTYPE_>	_Myt;
protected:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

protected:
	// init@C
	_Mychar		m_Path[MAX_PATH];

public:
	// RXgN^
	CTPrivateProfile(void);
	// fXgN^
	virtual ~CTPrivateProfile(void);
public:
	// J
	virtual void	Open(_Mylpcstr path);
	// 
	virtual void	Close(void);

public:

	// ZNV擾
	DWORD		GetSectionNames(_Mylpstr lpReturn, DWORD nSize)	const;
	// ZNVɑ݂L[擾
	DWORD		GetSection	(_Mylpcstr lpAppName, _Mylpstr lpReturn, DWORD nSize)	const;
	// t@C當擾
	DWORD		GetString	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpDefault, _Mylpstr lpReturn, DWORD nSize)	const;
	// t@C琮l擾
	UINT		GetInt		(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, INT nDefault)	const;
	// t@CHEXl擾
	DWORD		GetHex		(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwDefault)	const;
	// t@C珬l擾
	float		GetFloat	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fDefault)	const;
	// t@C\̂擾
	BOOL		GetStruct	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize)	const;
	// t@CWINDOWPLACEMENT擾
	BOOL		GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPWINDOWPLACEMENT lpwdpl)	const;
	BOOL		GetWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd)	const;

	// t@CɃL[
	BOOL		WriteSection(_Mylpcstr lpAppName, _Mylpcstr lpString);
	// t@Cɐl
	BOOL		WriteInt	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, UINT nValue);
	// t@Cɏl
	BOOL		WriteFloat	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, float fValue);
	// t@CHEXl
	BOOL		WriteHex	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, DWORD dwValue);
	// t@Cɕ
	BOOL		WriteString	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, _Mylpcstr lpString);
	// t@Cɍ\̂
	BOOL		WriteStruct	(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, LPVOID lpStruct, DWORD nSize);
	// t@CWINDOWPLACEMENT
	BOOL		WriteWindowPlacement(_Mylpcstr lpAppName, _Mylpcstr lpKeyName, HWND hWnd);

	// t@CL[폜
	BOOL		RemoveKey(_Mylpcstr lpAppName, _Mylpcstr lpKeyName);
	// t@CZNV폜
	BOOL		RemoveSection(_Mylpcstr lpAppName);
	// t@C폜
	BOOL		Remove(void);

public:
	// JĂ邩
	bool		IsOpen(void)	const	{ return (m_Path[0] != TEXT('\0')); }
	// 󂩂ǂ
	bool		IsEmpty(void)	const;

public:
	//
	static		DWORD	GetSection(_Mylpcstr lpAppName, _Mylpstr lpReturn, DWORD nSize, _Mylpcstr lpszPath);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
