//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaringTable.cpp
 * @brief		StringTablet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStringTable_CPP_

//======================================================================
// include
#include "WXStringTable.h"

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// define
// ŏ
#ifndef STRING_TABLE_LENGTH_MIN
#define STRING_TABLE_LENGTH_MIN		64
#endif
// ő啶
// Ȃ̏ꍇ͒`Ȃ
//#define STRING_TABLE_LENGTH_MAX		1024

// 擾x
// (STRING_TABLE_LENGTH_MINSTRING_TABLE_ACCURACYZẴobt@𐶐B)
#ifndef STRING_TABLE_ACCURACY
#define STRING_TABLE_ACCURACY		64	
#endif

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTStringTable<CHARTYPE_>::CTStringTable(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTStringTable<CHARTYPE_>::~CTStringTable(void)
{
	for( iterator it = m_StringArray.begin(); it != m_StringArray.end(); )
	{
		_Mylpstr p = it->second;
		it = m_StringArray.erase(it);
		delete [] p;
	}
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
template<typename CHARTYPE_>
CHARTYPE_* CTStringTable<CHARTYPE_>::Get(UINT uID, _Mylpstr pDefString)	const
{
	return Get(GetModuleHandle(nullptr), uID, pDefString);
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	uID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
template<typename CHARTYPE_>
CHARTYPE_* CTStringTable<CHARTYPE_>::Get(HINSTANCE hInst, UINT uID, _Mylpstr pDefString)	const
{
	_Mylpstr pString = nullptr;

	// LbV猟
	{
		_Mykey key(hInst, uID);
		iterator it = m_StringArray.find(key);
		if( it != m_StringArray.end() )
		{
			return it->second;
		}
	}

#ifdef STRING_TABLE_LENGTH_MAX
	_Mychar tmp[STRING_TABLE_LENGTH_MAX+1];
	int len = Load(hInst, id, tmp, STRING_TABLE_LENGTH_MAX+1);
	if( len == 0 )
	{
		// s
		// \[X݂Ȃ
		return pDefString;
	}
	pString = new _Mychar [len+1];
	Load(hInst, id, pString, len+1);
#else
	int dwLen = STRING_TABLE_LENGTH_MIN;
	while(1)
	{
		pString = new _Mychar [dwLen+1];
		if( pString == nullptr ) 
		{
			// obt@mۂɎs
			return pDefString;
		}
		int len = Load(hInst, uID, pString, dwLen+1);
		if( len == 0 )
		{
			// s
			// \[X݂Ȃ
			return pDefString;
		}
		if( len < dwLen ) 
		{
#if 1
			delete [] pString;
			pString = new _Mychar [len+1];
			Load(hInst, uID, pString, len+1);
#endif
			break;	// I
		}
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen >= STRING_TABLE_LENGTH_MAX ) break;	// ő啶
#endif

		// mۂobt@StringTableł
		dwLen += STRING_TABLE_ACCURACY;
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen > STRING_TABLE_LENGTH_MAX ) dwLen = STRING_TABLE_LENGTH_MAX;
#endif
		delete [] pString;
	}
#endif
	m_StringArray.insert(std::pair<_Mykey, _Mylpstr>(_Mykey(hInst, uID), pString));
	return pString;
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst			= CX^Xnh
 * @param [in]	uID				= \[XID
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	cchBufferMax	= o̓obt@TCY
 * @return	񂾃TCY
*//***********************************************************************/
template<>
int CTStringTable<CHAR>::Load(HINSTANCE hInst, UINT uID, _Mylpstr lpBuffer, int cchBufferMax)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::LoadStringA(hInst, uID, lpBuffer, cchBufferMax);
#else
	return FALSE;
#endif
}
template<>
int CTStringTable<WCHAR>::Load(HINSTANCE hInst, UINT uID, _Mylpstr lpBuffer, int cchBufferMax)
{
	return ::LoadStringW(hInst, uID, lpBuffer, cchBufferMax);
}

template class CTStringTable<CHAR>;
template class CTStringTable<WCHAR>;


}	// end of namespace wx
}	// end of namespace iris
