//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVersionInfo.cpp
 * @brief		o[Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXVersionInfo_CPP_

//======================================================================
// include
#include "WXVersionInfo.h"
#include "../os/WXModule.h"
#include "iris_xchar.hpp"
#include <stdio.h>
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if !defined(IRIS_WIN32_WCE)
#    pragma comment (lib,"version.lib")
#  endif
#endif

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTVersionInfo<CHARTYPE_>::CTVersionInfo()
: m_pVI(nullptr)
, m_pLCIDs(nullptr)
, m_LCIDListNum(0)
, m_LCID(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTVersionInfo<CHARTYPE_>::~CTVersionInfo()
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTVersionInfo<CHARTYPE_>::Open(void)
{
	_Mychar name[MAX_PATH];
	CModule module;
	module.GetFileName(name);
	return Open(name);
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= W[
 * @return	
*//***********************************************************************/
template<>
bool CTVersionInfo<CHAR>::Open(_Mylpstr filename)
{
#if	!defined(IRIS_WIN32_WCE)
	DWORD handle;
	DWORD dwVerInfoSize = GetFileVersionInfoSizeA(filename, &handle);
	if( dwVerInfoSize <= 0 ) return false;
	m_pVI = new char [dwVerInfoSize];
	GetFileVersionInfoA(filename, handle, dwVerInfoSize, m_pVI);
	// 擾Ă
	// m_pWord[0] == Zbg m_pWord[1] == LN^Zbg
	UINT len = GetQueryValue("\\VarFileInfo\\Translation",(LPVOID*)&m_pLCIDs);
	if( len == 0 ) return false;
	m_LCIDListNum = len / sizeof(LCID);
	LoadLCID();
	return true;
#else
	return false;
#endif
}
template<>
bool CTVersionInfo<WCHAR>::Open(_Mylpstr filename)
{
	DWORD handle;
	DWORD dwVerInfoSize = GetFileVersionInfoSizeW(filename, &handle);
	if( dwVerInfoSize <= 0 ) return false;
	m_pVI = new char [dwVerInfoSize];
	GetFileVersionInfoW(filename, handle, dwVerInfoSize, m_pVI);
	// 擾Ă
	// m_pWord[0] == Zbg m_pWord[1] == LN^Zbg
	UINT len = GetQueryValue(L"\\VarFileInfo\\Translation",(LPVOID*)&m_pLCIDs);
	if( len == 0 ) return false;
	m_LCIDListNum = len / sizeof(LCID);
	LoadLCID();
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTVersionInfo<CHARTYPE_>::Close(void)
{
	// m_pVI΁AVerQueryValueŊmۂ̈炵B
	delete [] m_pVI;
	m_pVI = nullptr;
	m_pLCIDs = nullptr;
	m_LCIDListNum = 0;
	m_LCID = 0;
}

//**********************************************************************
//
// e̎擾
//
//**********************************************************************
//! Ж
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetCompanyName(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "CompanyName")	,(LPVOID*)dst);
}
//! 
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetFileDescription(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "FileDescription"),(LPVOID*)dst);
}
//! t@Co[W
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetFileVersion(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "FileVersion")	,(LPVOID*)dst);
}
//! 
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetInternalName(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "InternalName")	,(LPVOID*)dst);
}
//! 쌠
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetLegalCopyright(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "LegalCopyright")	,(LPVOID*)dst);
}
//! t@C
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetOriginalFileName(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "OriginalFileName"),(LPVOID*)dst);
}
//! i
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetProductName(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "ProductName")	,(LPVOID*)dst);
}
//! io[W
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetProductVersion(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "ProductVersion")	,(LPVOID*)dst);
}
//! Rg
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetComments(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "Comments")		,(LPVOID*)dst);
}
//! W
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetLegalTrademarks(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "LegalTrademarks"),(LPVOID*)dst);
}
//! vCx[grh
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetPrivateBuild(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "PrivateBuild")	,(LPVOID*)dst);
}
//! XyVrh
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetSpecialBuild(_Mychar** dst) const
{
	return GetStringFileInfo(IRIS_XTEXT(_Mychar, "SpecialBuild")	,(LPVOID*)dst);
}

/**********************************************************************//**
 *
 * StringFileInfo̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nID	= 
 * @param [out]	dst	= o̓obt@
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetStringFileInfoFromID(int nID, _Mychar** dst) const
{
	switch( nID )
	{
	case COMPANYNAME:
		return GetCompanyName(dst);
	case FILEDESCRIPTION:
		return GetFileDescription(dst);
	case FILEVERSION:
		return GetFileVersion(dst);
	case INTERNALNAME:
		return GetInternalName(dst);
	case LEGALCOPYRIGHT:
		return GetLegalCopyright(dst);
	case ORIGINALFILENAME:
		return GetOriginalFileName(dst);
	case PRODUCTNAME:
		return GetProductName(dst);
	case PRODUCTVERSION:
		return GetProductVersion(dst);
	case COMMENTS:
		return GetComments(dst);
	case LEGALTRADEMARKS:
		return GetLegalTrademarks(dst);
	case PRIVATEBUILD:
		return GetPrivateBuild(dst);
	case SPECIALBUILD:
		return GetSpecialBuild(dst);
	}
	return 0;
}

/**********************************************************************//**
 *
 * o[W̎擾(10i)
 *
 ----------------------------------------------------------------------
 * @return	o[W(10i)
*//***********************************************************************/
template<typename CHARTYPE_>
int CTVersionInfo<CHARTYPE_>::GetVersionInt(void) const
{
	_Mylpstr v;
	_Mylpstr p;
	GetProductVersion(&v);
	return xcstol(v, &p, 10);
}

/**********************************************************************//**
 *
 * o[W̎擾(16i)
 *
 ----------------------------------------------------------------------
 * @return	o[W(16i)
*//***********************************************************************/
template<typename CHARTYPE_>
int CTVersionInfo<CHARTYPE_>::GetVersionHex(void) const
{
	_Mylpstr v;
	_Mylpstr p;
	GetProductVersion(&v);
	return xcstol(v, &p, 16);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	block_name	= ubN
 * @param [out]	dst			= o
 * @return	ǂݍ񂾃obt@
*//***********************************************************************/
template<>
UINT CTVersionInfo<CHAR>::GetQueryValue(_Mylpstr block_name, LPVOID* dst) const
{
#if	!defined(IRIS_WIN32_WCE)
	UINT len=0;
	if( VerQueryValueA(m_pVI, block_name, dst, &len) == 0 ) return 0;
	return len;
#else
	return 0;
#endif
}
template<>
UINT CTVersionInfo<WCHAR>::GetQueryValue(_Mylpstr block_name, LPVOID* dst) const
{
	UINT len=0;
	if( VerQueryValueW(m_pVI, block_name, dst, &len) == 0 ) return 0;
	return len;
}

/**********************************************************************//**
 *
 * StringFileInfo̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	block_name	= ubN
 * @param [out]	dst			= o
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
UINT CTVersionInfo<CHARTYPE_>::GetStringFileInfo(_Mylpcstr block_name, LPVOID* dst) const
{
	_Mychar key[256];
	xsprintf_s(key, 256, IRIS_XTEXT(_Mychar, "\\StringFileInfo\\%08x\\%s"), m_LCID, block_name );
	return GetQueryValue(key, dst);
}

template class CTVersionInfo<CHAR>;
template class CTVersionInfo<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
