//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXActiveDesktop.h
 * @brief		ActiveDesktopNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXActiveDesktop_H_
#define INCG_IRIS_WXActiveDesktop_H_

//======================================================================
// include
#include "iris_object.h"
#include "../com/WXCom.h"
#include <wininet.h>	// _WININET_Kv
#include "shlobj_inchead.h"

#if	defined(IRIS_WIN32_WCE)
typedef struct _tagWALLPAPEROPT 
{
	DWORD dwSize;
	DWORD dwStyle;
} WALLPAPEROPT, *LPWALLPAPEROPT;
typedef CONST WALLPAPEROPT	*LPCWALLPAPEROPT;

#define AD_APPLY_SAVE				0x00000001
#define AD_APPLY_HTMLGEN			0x00000002
#define AD_APPLY_REFRESH			0x00000004
#define AD_APPLY_ALL				(AD_APPLY_SAVE | AD_APPLY_HTMLGEN | AD_APPLY_REFRESH)
#define AD_APPLY_FORCE				0x00000008
#define AD_APPLY_BUFFERED_REFRESH	0x00000010
#define AD_APPLY_DYNAMICREFRESH		0x00000020

#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ActiveDesktopNX
 * @note	UNICODE
*/
class CActiveDesktop : public CCom, public INonCopyable<CActiveDesktop>
{
protected:
#if	!defined(IRIS_WIN32_WCE)
	LPACTIVEDESKTOP	m_pAD;	//!< ActiveDesktop ComIuWFNg
#endif

public:
	// RXgN^
	CActiveDesktop(void);
	// fXgN^
	~CActiveDesktop(void);

public:
	// 
	BOOL	Initialize(void);
	// 
	void	Release(void);

public:
	// ANeBx[g
	HRESULT	Activate(BOOL bComponents, BOOL bActiveDesktop);

public:
	// wrap
	HRESULT	ApplyChanges(DWORD dwFlags);

	template<typename CHARTYPE_>
	HRESULT	GetWallpaper(CHARTYPE_* lpszWallpaper, UINT cchWallpaper, DWORD dwReserved=0) const;

	template<typename CHARTYPE_>
	HRESULT	SetWallpaper(const CHARTYPE_* lpszWallpaper, DWORD dwReserved=0);

	HRESULT	GetWallpaperOptions(LPWALLPAPEROPT  lpwpo, DWORD dwReserved=0) const;
	HRESULT	SetWallpaperOptions(LPCWALLPAPEROPT lpwpo, DWORD dwReserved=0);

	template<typename CHARTYPE_>
	HRESULT	GetPattern(CHARTYPE_* lpszPattern, UINT cchPattern, DWORD dwReserved=0) const;

	template<typename CHARTYPE_>
	HRESULT	SetPattern(const CHARTYPE_* lpszPattern, DWORD dwReserved=0);

#if	!defined(IRIS_WIN32_WCE)
	HRESULT	GetDesktopItemOptions(LPCOMPONENTSOPT  lpco, DWORD dwReserved=0) const;
	HRESULT	SetDesktopItemOptions(LPCCOMPONENTSOPT lpco, DWORD dwReserved=0);

	HRESULT	AddDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	AddDesktopItemWithUI(HWND hWnd, LPCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	ModifyDesktopItem(LPCCOMPONENT lpcomp, DWORD dwFlags);
	HRESULT	RemoveDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	GetDesktopItemCount(LPINT lpiCount, DWORD dwReserved=0) const;

	HRESULT	GetDesktopItem(int nComponent, LPCOMPONENT lpcomp, DWORD dwReserved=0) const;
	HRESULT	GetDesktopItemByID(ULONG_PTR dwID, LPCOMPONENT lpcomp, DWORD dwReserved=0) const;

	template<typename CHARTYPE_>
	HRESULT	GenerateDesktopItemHtml(const CHARTYPE_* lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved=0);

	template<typename CHARTYPE_>
	HRESULT	AddUrl(HWND hWnd, const CHARTYPE_* lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags);

	template<typename CHARTYPE_>
	HRESULT	GetDesktopItemBySource(const CHARTYPE_* lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved=0) const;
#endif
};

}	// end of namespace wx
}	// end of namespace iris

#endif
