//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXContentType.cpp
 * @brief		ContentTypet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXContentType_CPP_

//======================================================================
// include
#include "WXContentType.h"
#include "WXShellPath.h"

namespace iris {
namespace wx
{

//======================================================================
// define
#define CONTENT_TYPE_TEXT(X, sub)			X("text/") X(sub)
#define CONTENT_TYPE_IMAGE(X, sub)			X("image/") X(sub)
#define CONTENT_TYPE_APP(X, sub)			X("application/") X(sub)
#define CONTENT_TYPE_MESSAGE(X, sub)		X("message/") X(sub)
#define CONTENT_TYPE_AUDIO(X, sub)			X("audio/") X(sub)
#define CONTENT_TYPE_VIDEO(X, sub)			X("video/") X(sub)
#define CONTENT_TYPE_MODEL(X, sub)			X("model/") X(sub)
#define CONTENT_TYPE_MULTIPART(X, sub)		X("multipart/") X(sub)

#define	CONTENT_TYPES(X)	  CONTENT_TYPE_TEXT		(X, "plain")		\
							, CONTENT_TYPE_TEXT		(X, "richtext")	\
							, CONTENT_TYPE_TEXT		(X, "enriched")	\
							, CONTENT_TYPE_TEXT		(X, "tab-separated-values")	\
							, CONTENT_TYPE_TEXT		(X, "html")	\
							, CONTENT_TYPE_TEXT		(X, "sgml")	\
							, CONTENT_TYPE_TEXT		(X, "uri-list")	\
							, CONTENT_TYPE_TEXT		(X, "rfc822-headers")	\
							, CONTENT_TYPE_TEXT		(X, "prs.lines.tag")	\
							, CONTENT_TYPE_TEXT		(X, "css")	\
							, CONTENT_TYPE_TEXT		(X, "xml")	\
							, CONTENT_TYPE_TEXT		(X, "rtf")	\
							, CONTENT_TYPE_TEXT		(X, "directory")	\
							, CONTENT_TYPE_TEXT		(X, "calendar")	\
							, CONTENT_TYPE_TEXT		(X, "t140")	\
							, CONTENT_TYPE_TEXT		(X, "parityfec")	\
							, CONTENT_TYPE_IMAGE	(X, "jpeg")	\
							, CONTENT_TYPE_IMAGE	(X, "gif")	\
							, CONTENT_TYPE_IMAGE	(X, "ief")	\
							, CONTENT_TYPE_IMAGE	(X, "g3fax")	\
							, CONTENT_TYPE_IMAGE	(X, "tiff")	\
							, CONTENT_TYPE_IMAGE	(X, "cgm")	\
							, CONTENT_TYPE_IMAGE	(X, "naplps")	\
							, CONTENT_TYPE_IMAGE	(X, "png")	\
							, CONTENT_TYPE_IMAGE	(X, "prs.btif")	\
							, CONTENT_TYPE_IMAGE	(X, "prs.pti")	\
							, CONTENT_TYPE_APP		(X, "octet-stream")	\
							, CONTENT_TYPE_APP		(X, "postscript")	\
							, CONTENT_TYPE_APP		(X, "oda")	\
							, CONTENT_TYPE_APP		(X, "atomicmail")	\
							, CONTENT_TYPE_APP		(X, "andrew-inset")	\
							, CONTENT_TYPE_APP		(X, "slate")	\
							, CONTENT_TYPE_APP		(X, "wita")	\
							, CONTENT_TYPE_APP		(X, "dec-dx")	\
							, CONTENT_TYPE_APP		(X, "dca-rft")	\
							, CONTENT_TYPE_APP		(X, "activemessage")	\
							, CONTENT_TYPE_APP		(X, "rtf")	\
							, CONTENT_TYPE_APP		(X, "applefile")	\
							, CONTENT_TYPE_APP		(X, "mac-binhex40")	\
							, CONTENT_TYPE_APP		(X, "news-message-id")	\
							, CONTENT_TYPE_APP		(X, "news-transmission")	\
							, CONTENT_TYPE_APP		(X, "wordperfect5.1")	\
							, CONTENT_TYPE_APP		(X, "pdf")	\
							, CONTENT_TYPE_APP		(X, "zip")	\
							, CONTENT_TYPE_APP		(X, "macwriteii")	\
							, CONTENT_TYPE_APP		(X, "msword")	\
							, CONTENT_TYPE_APP		(X, "remote-printing")	\
							, CONTENT_TYPE_APP		(X, "mathematica")	\
							, CONTENT_TYPE_APP		(X, "cybercash")	\
							, CONTENT_TYPE_APP		(X, "commonground")	\
							, CONTENT_TYPE_APP		(X, "iges")	\
							, CONTENT_TYPE_APP		(X, "riscos")	\
							, CONTENT_TYPE_APP		(X, "eshop")	\
							, CONTENT_TYPE_APP		(X, "x400-bp")	\
							, CONTENT_TYPE_APP		(X, "sgml")	\
							, CONTENT_TYPE_APP		(X, "cals-1840")	\
							, CONTENT_TYPE_APP		(X, "pgp-encrypted")	\
							, CONTENT_TYPE_APP		(X, "pgp-signature")	\
							, CONTENT_TYPE_APP		(X, "pgp-keys")	\
							, CONTENT_TYPE_APP		(X, "set-payment-initiation")	\
							, CONTENT_TYPE_APP		(X, "set-payment")	\
							, CONTENT_TYPE_APP		(X, "set-registration-initiation")	\
							, CONTENT_TYPE_APP		(X, "set-registration")	\
							, CONTENT_TYPE_APP		(X, "sgml-open-catalog")	\
							, CONTENT_TYPE_APP		(X, "prs.alvestrand.titrax-sheet")	\
							, CONTENT_TYPE_APP		(X, "prs.nprend")	\
							, CONTENT_TYPE_APP		(X, "hyperstudio")	\
							, CONTENT_TYPE_APP		(X, "vemmi")	\
							, CONTENT_TYPE_APP		(X, "prs.cww")	\
							, CONTENT_TYPE_APP		(X, "marc")	\
							, CONTENT_TYPE_APP		(X, "pkcs7-mime")	\
							, CONTENT_TYPE_APP		(X, "pkcs7-signature")	\
							, CONTENT_TYPE_APP		(X, "pkcs10")	\
							, CONTENT_TYPE_APP		(X, "EDIFACT")	\
							, CONTENT_TYPE_APP		(X, "EDI-X12")	\
							, CONTENT_TYPE_APP		(X, "EDI-Consent")	\
							, CONTENT_TYPE_APP		(X, "xml")	\
							, CONTENT_TYPE_APP		(X, "batch-SMTP")	\
							, CONTENT_TYPE_APP		(X, "pkixcmp")	\
							, CONTENT_TYPE_APP		(X, "ipp")	\
							, CONTENT_TYPE_APP		(X, "ocsp-request")	\
							, CONTENT_TYPE_APP		(X, "ocsp-response")	\
							, CONTENT_TYPE_APP		(X, "pkix-cert")	\
							, CONTENT_TYPE_APP		(X, "pkix-crl")	\
							, CONTENT_TYPE_APP		(X, "index")	\
							, CONTENT_TYPE_APP		(X, "index.cmd")	\
							, CONTENT_TYPE_APP		(X, "index.response")	\
							, CONTENT_TYPE_APP		(X, "index.obj")	\
							, CONTENT_TYPE_APP		(X, "index.vnd")	\
							, CONTENT_TYPE_APP		(X, "http")	\
							, CONTENT_TYPE_APP		(X, "sdp")	\
							, CONTENT_TYPE_APP		(X, "iotp")	\
							, CONTENT_TYPE_APP		(X, "whoispp-query")	\
							, CONTENT_TYPE_APP		(X, "whoispp-response")	\
							, CONTENT_TYPE_APP		(X, "parityfec")	\
							, CONTENT_TYPE_APP		(X, "dvcs")	\
							, CONTENT_TYPE_APP		(X, "sieve")	\
							, CONTENT_TYPE_APP		(X, "beep+xml")	\
							, CONTENT_TYPE_APP		(X, "font-tdpfr")	\
							, CONTENT_TYPE_MESSAGE	(X, "rfc822")	\
							, CONTENT_TYPE_MESSAGE	(X, "partial")	\
							, CONTENT_TYPE_MESSAGE	(X, "external-body")	\
							, CONTENT_TYPE_MESSAGE	(X, "news")	\
							, CONTENT_TYPE_MESSAGE	(X, "http")	\
							, CONTENT_TYPE_MESSAGE	(X, "delivery-status")	\
							, CONTENT_TYPE_MESSAGE	(X, "disposition-notification")	\
							, CONTENT_TYPE_MESSAGE	(X, "s-http")	\
							, CONTENT_TYPE_AUDIO	(X, "basic")	\
							, CONTENT_TYPE_AUDIO	(X, "32kadpcm")	\
							, CONTENT_TYPE_AUDIO	(X, "L16")	\
							, CONTENT_TYPE_AUDIO	(X, "telephone-event")	\
							, CONTENT_TYPE_AUDIO	(X, "tone")	\
							, CONTENT_TYPE_AUDIO	(X, "prs.sid")	\
							, CONTENT_TYPE_AUDIO	(X, "mpeg")	\
							, CONTENT_TYPE_AUDIO	(X, "parityfec")	\
							, CONTENT_TYPE_AUDIO	(X, "MP4A-LATM")	\
							, CONTENT_TYPE_AUDIO	(X, "G.722.1")	\
							, CONTENT_TYPE_VIDEO	(X, "mpeg")	\
							, CONTENT_TYPE_VIDEO	(X, "quicktime")	\
							, CONTENT_TYPE_VIDEO	(X, "pointer")	\
							, CONTENT_TYPE_VIDEO	(X, "parityfec")	\
							, CONTENT_TYPE_VIDEO	(X, "MP4V-ES")	\
							, CONTENT_TYPE_MODEL	(X, "iges")	\
							, CONTENT_TYPE_MODEL	(X, "vrml")	\
							, CONTENT_TYPE_MODEL	(X, "mesh")	\
							, CONTENT_TYPE_MULTIPART(X, "mixed")	\
							, CONTENT_TYPE_MULTIPART(X, "alternative")	\
							, CONTENT_TYPE_MULTIPART(X, "digest")	\
							, CONTENT_TYPE_MULTIPART(X, "parallel")	\
							, CONTENT_TYPE_MULTIPART(X, "appledouble")	\
							, CONTENT_TYPE_MULTIPART(X, "header-set")	\
							, CONTENT_TYPE_MULTIPART(X, "form-data")	\
							, CONTENT_TYPE_MULTIPART(X, "related")	\
							, CONTENT_TYPE_MULTIPART(X, "report")	\
							, CONTENT_TYPE_MULTIPART(X, "voice-message")	\
							, CONTENT_TYPE_MULTIPART(X, "signed")	\
							, CONTENT_TYPE_MULTIPART(X, "encrypted")	\
							, CONTENT_TYPE_MULTIPART(X, "byteranges")	\
							X("")/*
							, CONTENT_TYPE_TEXT		(X, "vnd.latex-z")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.fmi.flexstor")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.abc")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.in3d.3dml")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.in3d.spot")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.wap.wml")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.wap.wmlscript")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.motorola.reflex")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.fly")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.wap.sl")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.wap.si")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.ms-mediapackage")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.IPTC.NewsML")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.IPTC.NITF")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.curl")	\
							, CONTENT_TYPE_TEXT		(X, "vnd.DMClientScript")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.dwg")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.svf")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.dxf")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.fpx")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.net-fpx")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.xiff")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.fastbidsheet")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.wap.wbmp")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.cns.inf2")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.mix")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.fujixerox.edmics-rlc")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.fujixerox.edmics-mmr")	\
							, CONTENT_TYPE_IMAGE	(X, "vnd.fst")	\
							, CONTENT_TYPE_APP		(X, "vnd.framemaker")	\
							, CONTENT_TYPE_APP		(X, "vnd.mif")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-excel")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-powerpoint")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-project")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-works")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-tnef")	\
							, CONTENT_TYPE_APP		(X, "vnd.svd")	\
							, CONTENT_TYPE_APP		(X, "vnd.music-niff")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-artgalry")	\
							, CONTENT_TYPE_APP		(X, "vnd.truedoc")	\
							, CONTENT_TYPE_APP		(X, "vnd.koan")	\
							, CONTENT_TYPE_APP		(X, "vnd.street-stream")	\
							, CONTENT_TYPE_APP		(X, "vnd.fdf")	\
							, CONTENT_TYPE_APP		(X, "vnd.seemail")	\
							, CONTENT_TYPE_APP		(X, "vnd.businessobjects")	\
							, CONTENT_TYPE_APP		(X, "vnd.meridian-slingshot")	\
							, CONTENT_TYPE_APP		(X, "vnd.xara")	\
							, CONTENT_TYPE_APP		(X, "vnd.rapid")	\
							, CONTENT_TYPE_APP		(X, "vnd.enliven")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-registration-wakeup")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-verification-wakeup")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-payment-wakeup")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-directory-service")	\
							, CONTENT_TYPE_APP		(X, "vnd.intertrust.digibox")	\
							, CONTENT_TYPE_APP		(X, "vnd.intertrust.nncp")	\
							, CONTENT_TYPE_APP		(X, "vnd.noblenet-web")	\
							, CONTENT_TYPE_APP		(X, "vnd.noblenet-sealer")	\
							, CONTENT_TYPE_APP		(X, "vnd.noblenet-directory")	\
							, CONTENT_TYPE_APP		(X, "vnd.webturbo")	\
							, CONTENT_TYPE_APP		(X, "vnd.shana.informed.formtemplate")	\
							, CONTENT_TYPE_APP		(X, "vnd.shana.informed.formdata")	\
							, CONTENT_TYPE_APP		(X, "vnd.shana.informed.package")	\
							, CONTENT_TYPE_APP		(X, "vnd.shana.informed.interchange")	\
							, CONTENT_TYPE_APP		(X, "vnd.$commerce_battelle")	\
							, CONTENT_TYPE_APP		(X, "vnd.osa.netdeploy")	\
							, CONTENT_TYPE_APP		(X, "vnd.ibm.MiniPay")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-jpnstore-wakeup")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-setstore-wakeup")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-verification")	\
							, CONTENT_TYPE_APP		(X, "vnd.japannet-registration")	\
							, CONTENT_TYPE_APP		(X, "vnd.hp-HPGL")	\
							, CONTENT_TYPE_APP		(X, "vnd.hp-PCL")	\
							, CONTENT_TYPE_APP		(X, "vnd.hp-PCLXL")	\
							, CONTENT_TYPE_APP		(X, "vnd.musician")	\
							, CONTENT_TYPE_APP		(X, "vnd.FloGraphIt")	\
							, CONTENT_TYPE_APP		(X, "vnd.intercon.formnet")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-asf")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecdis-update")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder6")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder6-s")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-wordpro")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-approach")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-1-2-3")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-organizer")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-screencam")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-freelance")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujitsu.oasys")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujitsu.oasys2")	\
							, CONTENT_TYPE_APP		(X, "vnd.swiftview-ics")	\
							, CONTENT_TYPE_APP		(X, "vnd.dna")	\
							, CONTENT_TYPE_APP		(X, "vnd.wt.stf")	\
							, CONTENT_TYPE_APP		(X, "vnd.dxr")	\
							, CONTENT_TYPE_APP		(X, "vnd.mitsubishi.misty-guard.trustweb")	\
							, CONTENT_TYPE_APP		(X, "vnd.ibm.modcap")	\
							, CONTENT_TYPE_APP		(X, "vnd.acucobol")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujitsu.oasys3")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujitsu.oasysprs")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujitsu.oasysgp")	\
							, CONTENT_TYPE_APP		(X, "vnd.visio")	\
							, CONTENT_TYPE_APP		(X, "vnd.netfpx")	\
							, CONTENT_TYPE_APP		(X, "vnd.audiograph")	\
							, CONTENT_TYPE_APP		(X, "vnd.epson.salt")	\
							, CONTENT_TYPE_APP		(X, "vnd.3M.Post-it-Notes")	\
							, CONTENT_TYPE_APP		(X, "vnd.novadigm.EDX")	\
							, CONTENT_TYPE_APP		(X, "vnd.novadigm.EXT")	\
							, CONTENT_TYPE_APP		(X, "vnd.novadigm.EDM")	\
							, CONTENT_TYPE_APP		(X, "vnd.claymore")	\
							, CONTENT_TYPE_APP		(X, "vnd.comsocaller")	\
							, CONTENT_TYPE_APP		(X, "vnd.yellowriver-custom-menu")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.chart")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.series")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.filerequest")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.fileupdate")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.seriesrequest")	\
							, CONTENT_TYPE_APP		(X, "vnd.ecowin.seriesupdate")	\
							, CONTENT_TYPE_APP		(X, "vnd.wrq-hp3000-labelled")	\
							, CONTENT_TYPE_APP		(X, "vnd.minisoft-hp3000-save")	\
							, CONTENT_TYPE_APP		(X, "vnd.ffsns")	\
							, CONTENT_TYPE_APP		(X, "vnd.hp-hps")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujixerox.docuworks")	\
							, CONTENT_TYPE_APP		(X, "vnd.anser-web-funds-transfer-initiation")	\
							, CONTENT_TYPE_APP		(X, "vnd.anser-web-certificate-issue-initiation")	\
							, CONTENT_TYPE_APP		(X, "vnd.is-xpr")	\
							, CONTENT_TYPE_APP		(X, "vnd.intu.qbo")	\
							, CONTENT_TYPE_APP		(X, "vnd.publishare-delta-tree")	\
							, CONTENT_TYPE_APP		(X, "vnd.cybank")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.alert")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.cacheop")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.list")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.listcmd")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.channel")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.bearer-choice")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.signal")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.alert-wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.cacheop-wbmxl")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.list-wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.listcmd-wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.channel-wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.uplanet.bearer-choice-wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.epson.quickanime")	\
							, CONTENT_TYPE_APP		(X, "vnd.commonspace")	\
							, CONTENT_TYPE_APP		(X, "vnd.fut-misnet")	\
							, CONTENT_TYPE_APP		(X, "vnd.xfdl")	\
							, CONTENT_TYPE_APP		(X, "vnd.intu.qfx")	\
							, CONTENT_TYPE_APP		(X, "vnd.epson.ssf")	\
							, CONTENT_TYPE_APP		(X, "vnd.epson.msf")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder7")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder7-s")	\
							, CONTENT_TYPE_APP		(X, "vnd.lotus-notes")	\
							, CONTENT_TYPE_APP		(X, "vnd.wap.wmlc")	\
							, CONTENT_TYPE_APP		(X, "vnd.wap.wmlscriptc")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite")	\
							, CONTENT_TYPE_APP		(X, "vnd.wap.wbxml")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.wem")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.kmr")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.adsi")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.fis")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.gotap")	\
							, CONTENT_TYPE_APP		(X, "vnd.motorola.flexsuite.ttc")	\
							, CONTENT_TYPE_APP		(X, "vnd.ufdl")	\
							, CONTENT_TYPE_APP		(X, "vnd.accpac.simply.imp")	\
							, CONTENT_TYPE_APP		(X, "vnd.accpac.simply.aso")	\
							, CONTENT_TYPE_APP		(X, "vnd.vcx")	\
							, CONTENT_TYPE_APP		(X, "vnd.previewsystems.box")	\
							, CONTENT_TYPE_APP		(X, "vnd.mediastation.cdkey")	\
							, CONTENT_TYPE_APP		(X, "vnd.pg.format")	\
							, CONTENT_TYPE_APP		(X, "vnd.pg.osasli")	\
							, CONTENT_TYPE_APP		(X, "vnd.hp-hpid")	\
							, CONTENT_TYPE_APP		(X, "vnd.Mobius.TXF")	\
							, CONTENT_TYPE_APP		(X, "vnd.Mobius.PLC")	\
							, CONTENT_TYPE_APP		(X, "vnd.Mobius.DIS")	\
							, CONTENT_TYPE_APP		(X, "vnd.Mobius.DAF")	\
							, CONTENT_TYPE_APP		(X, "vnd.Mobius.MSL")	\
							, CONTENT_TYPE_APP		(X, "vnd.cups-raster")	\
							, CONTENT_TYPE_APP		(X, "vnd.cups-postscript")	\
							, CONTENT_TYPE_APP		(X, "vnd.cups-raw")	\
							, CONTENT_TYPE_APP		(X, "vnd.triscape.mxs")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder75")	\
							, CONTENT_TYPE_APP		(X, "vnd.powerbuilder75-s")	\
							, CONTENT_TYPE_APP		(X, "vnd.dpgraph")	\
							, CONTENT_TYPE_APP		(X, "vnd.eudora.data")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujixerox.docuworks.binder")	\
							, CONTENT_TYPE_APP		(X, "vnd.vectorworks")	\
							, CONTENT_TYPE_APP		(X, "vnd.grafeq")	\
							, CONTENT_TYPE_APP		(X, "vnd.bmi")	\
							, CONTENT_TYPE_APP		(X, "vnd.ericsson.quickcall")	\
							, CONTENT_TYPE_APP		(X, "vnd.hzn-3d-crossword")	\
							, CONTENT_TYPE_APP		(X, "vnd.wap.slc")	\
							, CONTENT_TYPE_APP		(X, "vnd.wap.sic")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-injector")	\
							, CONTENT_TYPE_APP		(X, "vnd.fujixerox.ddd")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-account")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-identity-message")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-tool-message")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-tool-template")	\
							, CONTENT_TYPE_APP		(X, "vnd.groove-vcard")	\
							, CONTENT_TYPE_APP		(X, "vnd.ctc-posml")	\
							, CONTENT_TYPE_APP		(X, "vnd.canon-lips")	\
							, CONTENT_TYPE_APP		(X, "vnd.canon-cpdl")	\
							, CONTENT_TYPE_APP		(X, "vnd.trueapp")	\
							, CONTENT_TYPE_APP		(X, "vnd.s3sms")	\
							, CONTENT_TYPE_APP		(X, "vnd.mcd")	\
							, CONTENT_TYPE_APP		(X, "vnd.httphone")	\
							, CONTENT_TYPE_APP		(X, "vnd.informix-visionary")	\
							, CONTENT_TYPE_APP		(X, "vnd.msign")	\
							, CONTENT_TYPE_APP		(X, "vnd.ms-lrm")	\
							, CONTENT_TYPE_APP		(X, "vnd.contact.cmsg")	\
							, CONTENT_TYPE_APP		(X, "vnd.epson.esf")	\
							, CONTENT_TYPE_APP		(X, "vnd.mozilla.xul+xml")	\
							, CONTENT_TYPE_APP		(X, "vnd.palm")	\
							, CONTENT_TYPE_APP		(X, "vnd.fsc.weblaunch")	\
							, CONTENT_TYPE_APP		(X, "vnd.tve-trigger")	\
							, CONTENT_TYPE_APP		(X, "vnd.vividence.scriptfile")	\
							, CONTENT_TYPE_APP		(X, "vnd.hhe.lesson-player")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.qcelp")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.digital-winds")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.lucent.voice")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.octel.sbc")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.rhetorex.32kadpcm")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.vmx.cvsd")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.nortel.vbk")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.cns.anp1")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.cns.inf1")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.everad.plj")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.nuera.ecelp4800")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.nuera.ecelp7470")	\
							, CONTENT_TYPE_AUDIO	(X, "vnd.nuera.ecelp9600")	\
							, CONTENT_TYPE_VIDEO	(X, "vnd.vivo")	\
							, CONTENT_TYPE_VIDEO	(X, "vnd.motorola.video")	\
							, CONTENT_TYPE_VIDEO	(X, "vnd.motorola.videop")	\
							, CONTENT_TYPE_VIDEO	(X, "vnd.fvt")	\
							, CONTENT_TYPE_VIDEO	(X, "vnd.mpegurl")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.dwf")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.gtw")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.flatland.3dml")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.vtu")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.mts")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.gdl")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.gs-gdl")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.parasolid.transmit.text")	\
							, CONTENT_TYPE_MODEL	(X, "vnd.parasolid.transmit.binary	")	\
							, X("") 
							//*/

//======================================================================
// variable
#if !defined(UNICODE) || defined(_IRIS_SUPPORT_MULTIBYTE)
static const CHAR*  s_ContentTypeA[] = {
	CONTENT_TYPES(IRIS_TEXTA)
};
#endif
#if defined(UNICODE) || defined(_IRIS_SUPPORT_UNICODE)
static const WCHAR* s_ContentTypeW[] = {
	CONTENT_TYPES(IRIS_TEXTW)
};
#endif

//======================================================================
// function

/**********************************************************************//**
 *
 * ContentType̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	dst		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	fname	= t@C
 * @retval	0		= 擾Ɏs
 * @retval	!= 0	= o̓obt@ɏ񂾁iKvȁjTCY
*//***********************************************************************/
u32 GetContentType (LPTSTR dst, u32 size, LPCTSTR fname)
{
#ifdef UNICODE
	return GetContentTypeW(dst, size, fname);
#else
	return GetContentTypeA(dst, size, fname);
#endif
}
#if !defined(UNICODE) || defined(_IRIS_SUPPORT_MULTIBYTE)
/// iris::wx::GetContentType Q
u32 GetContentTypeA(LPSTR  dst, u32 size, LPCSTR  fname)
{
	if( fname != nullptr )
	{
		LPCSTR *pp = s_ContentTypeA;
		LPCSTR p = *pp;
		while( *p != '\0' )
		{
			if( CPathA::IsContentType(fname, p) )
			{
				if( dst != nullptr )
				{
					strcpy_s(dst, size, p);
				}
				return (u32)strlen(p) + 1;
			}
			++pp;
			p = *pp;
		}
	}
	return 0;
}
#endif
#if defined(UNICODE) || defined(_IRIS_SUPPORT_UNICODE)
/// iris::wx::GetContentType Q
u32 GetContentTypeW(LPWSTR dst, u32 size, LPCWSTR fname)
{
	if( fname != nullptr )
	{
		LPCWSTR *pp = s_ContentTypeW;
		LPCWSTR p = *pp;
		while( *p != '\0' )
		{
			if( CPathW::IsContentType(fname, p) )
			{
				if( dst != nullptr )
				{
					wcscpy_s(dst, size, p);
				}
				return (u32)wcslen(p) + 1;
			}
			++pp;
			p = *pp;
		}
	}
	return 0;
}
#endif

}	// end of namespace wx
}	// end of namespace iris
