//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXNotifyIcon.h
 * @brief		NotifyIconNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXNotifyIcon_H_
#define INCG_IRIS_WXNotifyIcon_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include <shellapi.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTNotifyIcon;

//======================================================================
// typedef
typedef CTNotifyIcon<CHAR>	CNotifyIconA;
typedef CTNotifyIcon<WCHAR>	CNotifyIconW;
typedef CTNotifyIcon<TCHAR>	CNotifyIcon;

//======================================================================
// class
//! NotifyIconNX
template<typename CHARTYPE_>
class CTNotifyIcon : public IIrisObject
{
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;

public:
#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (::cpp0x::is_same<_Mychar, WCHAR>::value), NOTIFYICONDATAW, NOTIFYICONDATAA >::type XNOTIFYICONDATA;
#else
	typedef NOTIFYICONDATA	XNOTIFYICONDATA;
#endif
	typedef XNOTIFYICONDATA	*LPXNOTIFYICONDATA;

protected:
	XNOTIFYICONDATA	m_Data;	//!< f[^
public:
	// RXgN^
	CTNotifyIcon(void);
	// fXgN^
	~CTNotifyIcon(void);

public:
	// ǉ
	BOOL	Add(HWND hWnd, UINT uID, UINT uFlags, UINT uCallbackMsg, HICON hIcon, _Mylpcstr lpszTip);
	BOOL	Add(LPXNOTIFYICONDATA lpnid);
	BOOL	Add(void);
	// ύX
	BOOL	Modify(void);
	// 폜
	BOOL	Delete(void);
	// tH[JX
	BOOL	SetFocus(void);
	// o[W
	BOOL	SetVersion(void);

public:
	// XgA
	BOOL	Restore(UINT uMsg);
	BOOL	Restore(void);
	// Explorer̍ċNbZ[W̎擾
	UINT	GetTaskbarCreatedMessage(void) const;

public:
	/**
	 * @brief	f[^̎擾
	*/
			XNOTIFYICONDATA&	GetData(void)				{ return m_Data; }
	const	XNOTIFYICONDATA&	GetData(void)		const	{ return m_Data; }

	/**
	 * @name	operator
	 * @{
	*/
	operator			XNOTIFYICONDATA (void)				{ return GetData(); }
	operator	const	XNOTIFYICONDATA (void)		const	{ return GetData(); }

			XNOTIFYICONDATA&	operator () (void)			{ return GetData(); }
	const	XNOTIFYICONDATA&	operator () (void)	const	{ return GetData(); }
	/**
	 * @}
	*/

private:
	// Shell_NotifyIcon
	static BOOL	NotifyIcon(DWORD dwMessage, LPXNOTIFYICONDATA lpnid);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
