//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellPath.h
 * @brief		pXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXShellPath_H_
#define INCG_IRIS_WXShellPath_H_

//======================================================================
// include
#include "iris_object.h"
#include "ml/iml_type_select.hpp"

namespace iris {
namespace wx
{

//======================================================================
// decalre
template<typename CHARTYPE_>class CTPath;

//======================================================================
// typedef
typedef CTPath<CHAR>	CPathA;
typedef CTPath<WCHAR>	CPathW;
typedef CTPath<TCHAR>	CPath;

//======================================================================
// class
//! pXNX
template<typename CHARTYPE_>
class CTPath : public IIrisObject
{
	typedef CTPath<CHARTYPE_>	_Myt;
protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
protected:
	// pXNXȂ̂Ńobt@MAX_PATHpӂȂ
	_Mychar	m_Path[MAX_PATH];

public:
	// RXgN^
	CTPath(void);
	CTPath(_Mylpcstr  lpszPath);
	// fXgN^
	~CTPath(void);

	/**
	 * @name	operator
	 * @{
	*/
	operator _Mylpstr   (void)			{ return GetPath(); }
	operator _Mylpcstr  (void)	const	{ return GetPath(); }
	_Mylpstr 	operator ()	(void)		{ return GetPath(); }
	_Mylpcstr 	operator ()	(void) const{ return GetPath(); }

public:

	_Mychar		operator [] (int nIndex) const			{ return m_Path[nIndex]; }
	_Myt&		operator =  (_Mylpcstr  lpString)		{ Copy(lpString); return *this; }
	_Myt&		operator += (_Mylpcstr  lpString);
	const _Myt	operator + (_Mylpcstr lpString)	const { _Myt ret(*this); ret += lpString; return ret; }
	/**
	 * @}
	*/

public:
	// Rs[
	void		Copy(_Mylpcstr lpszPath);

public:
	// obNXbVǉ
	_Mylpstr	AddBackslash(void);
	// gqǉ
	BOOL		AddExtension(_Mylpcstr pszExt);
	// t@Cǉ
	BOOL		AddFileName(_Mylpcstr pszFile);
	// pX̌
	BOOL		Append(_Mylpcstr  pszMore);
	// hCu[gpX̎擾
	BOOL		BuildRoot(int iDrive);
	// pX . A .. 폜
	BOOL		Canonicalize(void);
	BOOL		Canonicalize(_Mylpcstr  pszPath);
	// fBNgƃt@CpX̌
	BOOL		Combine(_Mylpcstr pszDir, _Mylpcstr pszFile);
	BOOL		CombineDirectory(_Mylpcstr pszDir);
	BOOL		CombineFile(_Mylpcstr pszFile);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPath(HDC hDC, UINT dx);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPathEx(UINT cchMax, DWORD dwFlags);
	BOOL		CompactPathEx(_Mylpstr  pszDst, UINT cchMax, DWORD dwFlags);
	// Q̃pX狤ʂ̃pXo
	BOOL		CommonPrefix(_Mylpcstr  pszFile1, _Mylpcstr  pszFile2);
	// pXWJpXɕϊ
	BOOL		ExpandEnvStrings(_Mylpcstr  lpSrc);
	// t@C݂邩ǂ
	BOOL		FileExists(void);
	// gq
	_Mylpstr 	FindExtension(void);
	// t@C
	_Mylpstr 	FindFileName(void);
	// ̍\vf
	_Mylpstr 	FindNextComponent(void);
	// Ō̍\vf
	_Mylpstr 	FindLastComponent(void);
	// WpXEPathst@C
	BOOL		FindOnPath(_Mylpstr pszPath, _Mylpcstr * ppszOtherDirs);
	// TtBbNX̌
	_Mylpcstr 	FindSuffixArray(_Mylpcstr * lppSuffix, int nArraySize);
	// ̕񂩂R}hC擾
	_Mylpstr 	GetArgs(void);
	// hCuԍ̎擾
	int			GetDriveNumber(void);
	// ̃Rec^Cvǂ
	BOOL		IsContentType(_Mylpcstr pszContentType);
	// fBNg݂邩ǂ
	BOOL		IsDirectory(void);
	// fBNg󂩂ǂ
	BOOL		IsDirectoryEmpty(void);
	// ؂蕶邩ǂ
	BOOL		IsFileSpec(void);
	// pXtH[}bgǂ
	BOOL		IsLFNFileSpec(void);
	// lbg[ÑpXǂ
	BOOL		IsNetworkPath(void);
	// pX̕񂩂n܂Ă邩ǂ
	BOOL		IsPrefix(_Mylpcstr  pszPrefix);
	// pX΃pXǂ
	BOOL		IsRelative(void);
	// pX[gpXǂ
	BOOL		IsRoot(void);
	// pX̃[gpXǂ
	BOOL		IsSameRoot(_Mylpcstr pszPath);
	// pXVXet@Cǂ
	BOOL		IsSystemFolder(void);
	// pXUNC\Lł邩ǂ
	BOOL		IsUNC(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServer(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServerShare(void);
	// pXURL\Lł邩ǂ
	BOOL		IsURL(void);
	// 啶̃pXɕϊ
	BOOL		MakePretty(void);
	// t@CVXet@Cɂ
	BOOL		MakeSystemFolder(void);
	// pXɈv邩
	BOOL		MatchSpec(_Mylpcstr pszSpec);
	// 󔒂pX '"' 
	void		QuoteSpaces(void);
	// ̃pXԂ̑΃pX擾
	BOOL		RelativePathTo(_Mylpcstr pszFrom, DWORD dwAttrFrom, _Mylpcstr pszTo, DWORD dwAttrTo);
	// obNXbV폜
	_Mylpstr 	RemoveBackslash(void);
	// pX̑Ő󔒂폜
	void		RemoveBlanks(void);
	// pXgq폜
	void		RemoveExtension(void);
	// pXt@C폜
	BOOL		RemoveFileSpec(void);
	// pX̊gqύX
	BOOL		RenameExtension(_Mylpcstr pszExt);
	// tpX߂
	BOOL		SearchAndQualify(_Mylpstr pszBuf, UINT cchBuf);
	BOOL		SearchAndQualify(_Mylpcstr pszPath);
	// k߂`̃pXRg[ɕ\
	void		SetDlgItemPath(HWND hDlg, int id);
	// pX狤L폜
	_Mylpstr 		SkipRoot(void);
	// pXt@Co
	void		StripPath(void);
	// pX烋[gpXo
	BOOL		StripToRoot(void);
	// pXϐgppXɕύX
	BOOL		UnExpandEnvStrings(_Mylpstr pszBuf, UINT cchBuf);
	// pXC폜
	void		Undecorate(void);
	// t@CVXet@CłȂ
	BOOL		UnmakeSystemFolder(void);
	// pX̑Õ_uNH[e[V폜
	void		UnquoteSpaces(void);
	
public:
	_Mylpstr 	GetPath(void)			{ return m_Path; }				//!< pX擾
	_Mylpcstr 	GetPath(void)	const	{ return m_Path; }				//!< pX擾
	size_t		GetSize(void)	const	{ return sizeof(m_Path); }		//!< obt@TCY擾
	size_t		GetLength(void) const	{ return MAX_PATH; }			//!< 񒷂擾

public:
	// original function
	// t@CɎgȂ폜
	BOOL		FormatFileName(_Mylpcstr  pszFile, s32 max_len);

public:
	// static function
	//  m_PathgpKvȂ̂
	// t@C݂邩ǂ
	static	BOOL		FileExists(_Mylpcstr pszPath);
	// ̍\vf
	static	_Mylpstr 	FindNextComponent(_Mylpcstr pszPath);
	// ̕񂩂R}hC擾
	static	_Mylpstr 	GetArgs(_Mylpcstr pszPath);
	// pX\镶̎ʂ𔻒
	static	UINT		GetCharType(_Mychar ch);
	// ̃Rec^Cvǂ
	static	BOOL		IsContentType(_Mylpcstr pszPath, _Mylpcstr pszContentType);
	// ̃t@CVXet@Cǂ
	static	BOOL		IsSystemFolder(DWORD dwAttrb);
	// ACRpXt@CpXƃCfbNX擾
	static	int			ParseIconLocation(_Mylpstr pszIconFile);
	// R}hC폜
	static	void		RemoveArgs(_Mylpstr pszPath);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
