//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHFileOpen.h
 * @brief		t@CI[v_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHFileOpen_H_
#define INCG_IRIS_WXSHFileOpen_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include <commdlg.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSHFileOpen;

//======================================================================
// typedef
typedef CTSHFileOpen<CHAR>	CSHFileOpenA;
typedef CTSHFileOpen<WCHAR>	CSHFileOpenW;
typedef CTSHFileOpen<TCHAR>	CSHFileOpen;

//======================================================================
// class
/**
 * @brief	tH_I_CAONX
*/
template<typename CHARTYPE_>
class CTSHFileOpen : public IIrisObject
{
private:
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;
	typedef CTSHFileOpen<CHARTYPE_>	_Myt;
public:
	typedef typename iml::type_select< (cpp0x::is_same<_Mychar, WCHAR>::value), OPENFILENAMEW, OPENFILENAMEA >::type XOPENFILENAME;
	typedef XOPENFILENAME		*LPXOPENFILENAME;

public:
	// J
	static	BOOL	Show(HWND hWnd, _Mylpcstr lpszTitle, _Mylpcstr lpszFilter, _Mylpstr lpszFileName
		, DWORD dwSize, DWORD Flags, LPXOPENFILENAME lpofn=nullptr);

	//
	static	BOOL	Open(LPXOPENFILENAME lpofn);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
