package jp.sourceforge.jnfc;

import jp.sourceforge.jnfc.FelicaNfcLibrary.DEVICE_INFO;
import jp.sourceforge.jnfc.MyUser32.UNIT;
import jp.sourceforge.jnfc.MyUser32.WNDCLASSEX;
import jp.sourceforge.jnfc.MyUser32.WNDPROC;
import jp.sourceforge.jnfc.NFCStructure.DeviceCard;
import jp.sourceforge.jnfc.NFCStructure.DeviceInfo;
import jp.sourceforge.jnfc.NFCStructure.Felica;
import jp.sourceforge.jnfc.NFCStructure.NFC14443A;
import jp.sourceforge.jnfc.NFCStructure.NFC14443B;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.X11.Atom;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef.HINSTANCE;
import com.sun.jna.platform.win32.WinDef.HWND;
import com.sun.jna.platform.win32.WinDef.LPARAM;
import com.sun.jna.platform.win32.WinDef.LRESULT;
import com.sun.jna.platform.win32.WinDef.WPARAM;
import com.sun.jna.platform.win32.WinUser.MSG;


public class NFC implements WNDPROC {

	private int card_find_message;
	private int card_enable_message;
	private HWND hWnd;

	private final int WM_DESTROY = 0x00000002;


    // Felica COMMAND
	public static final byte FELICA_REQUEST_SERVICE_REQUEST_CMD = 0x02;
	public static class FELICA_REQUEST_SERVICE_REQUEST extends Structure {
    	public byte cmdCode = FELICA_REQUEST_SERVICE_REQUEST_CMD;
    	public byte[] IDm = new byte[8];
    	public byte areaServiceNum;
    	public byte[] areaServiceList;
	}
	public static final byte FELICA_REQUEST_SERVICE_RESPONSE_CMD = 0x03;
	public static class FELICA_REQUEST_SERVICE_RESPONSE extends Structure {
    	public byte responseCode = (byte)0x00;
    	public byte[] IDm = new byte[8];
    	public byte areaServiceNum;
    	public byte[] areaServiceList;
	}
    public static final byte FELICA_READ_WITHOUT_ENCRYPTION_REQUEST_CMD = 0x06;
    public static class FELICA_READ_WITHOUT_ENCRYPTION_REQUEST extends Structure {

    	public byte cmdCode = FELICA_READ_WITHOUT_ENCRYPTION_REQUEST_CMD;
    	public byte[] IDm = new byte[8];
    	public byte serviceNum;
    	public byte[] serviceCodeList;
    	public byte blockNum;
    	public byte[] blockList;
    }
    public static final byte FELICA_READ_WITHOUT_ENCRYPTION_RESPONSE_CMD = 0x07;
    public static class FELICA_READ_WITHOUT_ENCRYPTION_RESPONSE extends Structure {

    	public FELICA_READ_WITHOUT_ENCRYPTION_RESPONSE(){}
    	public FELICA_READ_WITHOUT_ENCRYPTION_RESPONSE(Pointer p) {
    		super(p);
    	}

    	public byte responseCode = (byte)0x00;
    	public byte[] IDm = new byte[8];
    	public byte statusFlag1;
    	public byte statusFlag2;
    	public byte blockNum;
    	public byte[] blockList;
    }

	public NFC() {

		Runtime runtime = Runtime.getRuntime();
		runtime.addShutdownHook(new Thread() {
			public void run() {
				System.out.println("Vbg_Em܂B");
				MyUser32.INSTANCE.PostMessage(hWnd, 0, new WPARAM(0L), new LPARAM(0));
				if (hWnd != null) {
					try {
						stopPollMode();
					} catch (NFCException e) {
					} finally {
						try {
							stopDevAccess(FelicaNfcLibrary.NOT_RE_NOTIFICATION_SAME_DEVICE);
						} catch (NFCException e) {
						} finally {
							try {
								close();
							} catch (NFCException e) {
							} finally {
								try {
									uninitialize();
								} catch (NFCException e) {
								}
							}
						}
					}
				}
			}
		});
	}

	public void initialize() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_initialize()) {
			throw createNfcException();
		}
	}

	public void uninitialize() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_uninitialize()) {
			throw createNfcException();
		}
	}
	public void open(String portName) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_open(portName)) {
			throw createNfcException();
		}

		if (hWnd == null) {
			hWnd = createWindow(this);

			String msg_str_of_find = "find";
			String msg_str_of_enable = "enable";
			setPollCallbackParameters(hWnd, msg_str_of_find, msg_str_of_enable);

			card_find_message = MyUser32.INSTANCE.RegisterWindowMessage("find");
			card_enable_message = MyUser32.INSTANCE.RegisterWindowMessage("enable");
		}
	}

	public void close() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_close()) {
			throw createNfcException();
		}
	}

	public void startPollMode(int targetDevice) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_start_poll_mode(targetDevice)) {
			throw createNfcException();
		}
	}

	public void stopPollMode() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_stop_poll_mode()) {
			throw createNfcException();
		}
	}

	public void startDevAccess(int targetNumber) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_start_dev_access(targetNumber)) {
			throw createNfcException();
		}
	}

	public void stopDevAccess(int stopMode) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_stop_dev_access(stopMode)) {
			throw createNfcException();
		}
	}

	public void selectDevice() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_select_device()) {
			throw createNfcException();
		}
	}

	public void deselectDevice() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_deselect_device()) {
			throw createNfcException();
		}
	}

	public Pointer thru(
			Pointer commandPacketData,
			short commandPacketDataLength,
			Pointer responsePacketData,
			short responsePacketDataLength) throws NFCException {

		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_thru(
				commandPacketData,
				commandPacketDataLength,
				responsePacketData,
				responsePacketDataLength)) {
			throw createNfcException();
		}

		return responsePacketData;
	}

	public void setTimeout(int timeout) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_set_timeout(timeout)) {
			throw createNfcException();
		}
	}

	public int getTimeout() throws NFCException {

		int timeout = 0;

		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_get_timeout(timeout)) {
			throw createNfcException();
		}

		return timeout;
	}

	public void setPollCallbackParameters(
			HWND handle,
			final String msgStrOfFind,
			final String msgStrOfEnable) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_set_poll_callback_parameters(
				handle, msgStrOfFind, msgStrOfEnable)) {
			throw createNfcException();
		}
	}

	public int getLastError() throws NFCException {

		int[] errorInfo = new int[2];

		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_get_last_error(errorInfo)) {
			throw createNfcException();
		}

		return errorInfo[0];
	}

	public void startLogging(String fileName) throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_start_logging(fileName)) {
			throw createNfcException();
		}
	}

	public void stopLogging() throws NFCException {
		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_stop_logging()) {
			throw createNfcException();
		}
	}

	public DEVICE_INFO pollAndStartDevAccess(
			int targetDevice,
			int timeout) throws NFCException {

		DEVICE_INFO deviceInfo = new DEVICE_INFO();
		Pointer p = deviceInfo.getPointer();

		if (!FelicaNfcLibrary.INSTANCE.felicalib_nfc_poll_and_start_dev_access(
				targetDevice, timeout, p)) {
			throw createNfcException();
		}

		return deviceInfo;
	}


	public DeviceCard waitEvent() {

		DeviceCard deviceCard = null;

		MSG msg = new MSG();
		//int message = MyUser32.INSTANCE.GetMessage (msg, hWnd, 0, 0);

		if (msg.message == card_find_message) {
			DeviceInfo pDevInfo = new DeviceInfo(new Pointer(msg.lParam.intValue()));

			if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_14443A_18092_106K) {

				NFC14443A pDevNfc14443A =
						new NFC14443A(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("find", pDevInfo, pDevNfc14443A);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_14443B_106K) {

				NFC14443B pDevNfc14443B =
						new NFC14443B(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("find", pDevInfo, pDevNfc14443B);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_212K) {
				Felica pDevNfcFelica =
						new Felica(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("find", pDevInfo, pDevNfcFelica);

			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_424K) {
				Felica pDevNfcFelica =
						new Felica(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("find", pDevInfo, pDevNfcFelica);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_JEWEL_106K) {
				System.out.println("target device:DEVICE_TYPE_NFC_JEWEL_106K");
			} else {
				System.out.println("Unknown target device:" + pDevInfo.target_device);
			}
		} else if (msg.message == card_enable_message) {
			DeviceInfo pDevInfo = new DeviceInfo(new Pointer(msg.lParam.intValue()));

			if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_14443A_18092_106K) {

				NFC14443A pDevNfc14443A =
						new NFC14443A(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("enable", pDevInfo, pDevNfc14443A);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_14443B_106K) {

				NFC14443B pDevNfc14443B =
						new NFC14443B(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("enable", pDevInfo, pDevNfc14443B);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_212K) {
				Felica pDevNfcFelica =
						new Felica(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("enable", pDevInfo, pDevNfcFelica);

			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_424K) {
				Felica pDevNfcFelica =
						new Felica(new Pointer(msg.lParam.intValue() + 4));

				deviceCard = new DeviceCard("enable", pDevInfo, pDevNfcFelica);
			} else if (pDevInfo.target_device == FelicaNfcLibrary.DEVICE_TYPE_NFC_JEWEL_106K) {
				System.out.println("target device:DEVICE_TYPE_NFC_JEWEL_106K");
			} else {
				System.out.println("Unknown target device:" + pDevInfo.target_device);
			}

		} else {
			//System.out.println("msg:" + msg.message);
		}

		MyUser32.INSTANCE.TranslateMessage(msg);
		MyUser32.INSTANCE.DispatchMessage(msg);

		return deviceCard;
	}


	private NFCException createNfcException() {

		int[] errorInfo = new int[2];

		FelicaNfcLibrary.INSTANCE.felicalib_nfc_get_last_error(errorInfo);

		short n = (short)((errorInfo[0] << 8) + errorInfo[1]);

		return new NFCException(n);
	}

	private HWND createWindow(WNDPROC wndProc)	{
		HINSTANCE hInst;
		WNDCLASSEX wc = new WNDCLASSEX();
		hInst = (HINSTANCE)Kernel32.INSTANCE.GetModuleHandle(null);

		wc.cbClsExtra = 0;
		wc.cbSize = wc.size();	// sizeof(WNDCLASSEX);
		wc.cbWndExtra = 0;
		wc.hbrBackground = null;	//(HBRUSH)(COLOR_DESKTOP+1);
		wc.hCursor = null;	//::LoadCursor(NULL,IDC_ARROW);
		wc.hIcon = null;
		wc.hIconSm = null;
		wc.hInstance = hInst;
		wc.lpfnWndProc = wndProc;
		wc.lpszClassName = "Sample";
		wc.lpszMenuName = null;
		wc.style = 1;	//CS_HREDRAW|CS_VREDRAW;

		Atom atom = MyUser32.INSTANCE.RegisterClassEx(wc);

		// EBhE쐬ԋp
		return MyUser32.INSTANCE.CreateWindowEx(
				  1,			// gEBhEX^C
				  atom,			// o^ĂNX
				  "FNC_Window",	// EBhE
				  1,			// EBhEX^C
				  1,			// EBhẺ̈ʒu
				  1,			// EBhȄc̈ʒu
				  1,			// EBhE̕
				  1,			// EBhE̍
				  0,			// eEBhE܂̓I[i[EBhẼnh
				  0,			// j[nh܂͎qʎq
				  hInst,		// AvP[VCX^X̃nh
				  0);			// EBhE쐬f[^
	}

	public LRESULT callback(HWND hWnd, UNIT uMsg, WPARAM wParam, LPARAM lParam) {

		//System.out.println("WndMessage:0x" + Integer.toHexString(uMsg.intValue()));
		switch (uMsg.intValue()) {
			case WM_DESTROY:
				System.out.println("PostQuitMessage");
				MyUser32.INSTANCE.PostQuitMessage(0);
				break;
			default:
				return MyUser32.INSTANCE.DefWindowProc(hWnd, uMsg, wParam, lParam);
		}
		return new LRESULT(0);
	}

}
