package jp.sourceforge.jnfc;

import jp.sourceforge.jnfc.FelicaNfcLibrary.DEVICE_DATA_NFC_14443A_18092_106K;
import jp.sourceforge.jnfc.FelicaNfcLibrary.DEVICE_DATA_NFC_14443B_106K;
import jp.sourceforge.jnfc.FelicaNfcLibrary.DEVICE_DATA_NFC_18092_212_424K;
import jp.sourceforge.jnfc.FelicaNfcLibrary.DEVICE_INFO;

import com.sun.jna.Pointer;

public interface NFCStructure {

	int TYPE_NFC_14443A = FelicaNfcLibrary.DEVICE_TYPE_NFC_14443A_18092_106K;
	int TYPE_NFC_18092_212K =
			FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_212K;
	int TYPE_NFC_18092_424K =
			FelicaNfcLibrary.DEVICE_TYPE_NFC_18092_424K;
	int TYPE_NFC_14443B = FelicaNfcLibrary.DEVICE_TYPE_NFC_14443B_106K;
	int TYPE_NFC_JEWEL_106 =
			FelicaNfcLibrary.DEVICE_TYPE_NFC_JEWEL_106K;

	public class DeviceCard {
		private final String event;
		private final DeviceInfo deviceInfo;
		private final DeviceData deviceData;

		public DeviceCard(String event, DeviceInfo deviceInfo, DeviceData deviceData) {
			this.event = event;
			this.deviceInfo = deviceInfo;
			this.deviceData = deviceData;
		}

		public String getEvent() {
			return event;
		}

		public DeviceInfo getDeviceInfo() {
			return deviceInfo;
		}

		public DeviceData getDeviceData() {
			return deviceData;
		}
	}

	public class DeviceInfo extends DEVICE_INFO {

		public DeviceInfo(Pointer p) {
			super(p);
		}

    	public int getTargetDevice() {
    		return target_device;
    	}

    	public byte getDevInfo() {
    		return dev_info[0];
    	}
	}

	public class NFC14443A extends DEVICE_DATA_NFC_14443A_18092_106K implements DeviceData {

		public NFC14443A(Pointer p) {
			super(p);
		}

    	public int getTargetNumber() {
    		return target_number;
    	}

    	public short getSensRes() {
    		return sens_res;
    	}

    	public byte getSelRes() {
    		return sel_res;
    	}

    	public byte getNFCID1Size() {
    		return NFCID1_size;
    	}

    	public byte[] getNFCID1() {
    		return NFCID1;
    	}

    	public byte getATSSize() {
    		return ATS_size;
    	}

    	public byte[] getATS() {
    		return ATS;
    	}
	}

	public class NFC14443B extends DEVICE_DATA_NFC_14443B_106K implements DeviceData {

		public NFC14443B(Pointer p) {
			super(p);
		}

		public int getTargetNumber() {
			return target_number;
		}
		public byte[] getATQB() {
			return ATQB;
		}
		public byte getATTRIBSize() {
			return ATTRIB_size;
		}
		public byte[] getATTRIB() {
			return ATTRIB;
		}
	}

	public class Felica extends DEVICE_DATA_NFC_18092_212_424K implements DeviceData {

		public Felica(Pointer p) {
			super(p);
		}

		public byte getId() {
			return id;
		}
		public int getTargetNumber() {
			return target_number;
		}
		public byte[] getNFCID2() {
			return NFCID2;
		}
		public byte[] getPad() {
			return Pad;
		}
		public byte getRDSize() {
			return RD_size;
		}
		public byte[] getRD() {
			return RD;
		}
	}

	public interface DeviceData {

	}
}
