package jp.kirikiri.tvp2.utils;

import java.util.HashSet;

/**
 * キーボードの状態を記憶するクラス
 * 各 Window に登録して、状態の変化を得る
 * ある程度期待道理に動くはずがだ、完全ではないので注意。
 */
public class KeyStateHelper {

	private HashSet<Integer> mKeyState;

	public KeyStateHelper() {
		mKeyState = new HashSet<Integer>();
	}

	public void setKey( int code ) {
		mKeyState.add( Integer.valueOf( code ) );
	}
	public void resetkey( int code ) {
		mKeyState.remove(Integer.valueOf(code));
	}
	public void clear() {
		mKeyState.clear();
	}
	public boolean isPressing( int code ) {
		return mKeyState.contains( code );
	}

}
