/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class ScrollTransHandlerProvider extends CrossFadeTransHandlerProvider {

	private static final String FROM = "from";
	private static final String STAY = "stay";

	@Override
	public String getName() { return "scroll"; }

	@Override
	public BaseTransHandler startTransition(SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h, int[] type) throws TJSException {

		BaseTransHandler ret = super.startTransition(options, imagepro, layertype, src1w, src1h, src2w, src2h, type);
		if( ret != null ) {
			if( type != null && type.length >= 2 ) type[1] = tutDivisible; // update type : divisible
		}
		return ret;
	}

	protected BaseTransHandler getTransitionObject( SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h ) throws TJSException {

		int er = options.getAsNumber( TIME, mLogValueRet );
		long time = mLogValueRet[0];
		if( er < 0 ) Message.throwExceptionMessage( Message.SpecifyOption, TIME );
		if(time < 2) time = 2; // too small time may cause problem

		// retrieve "from" option
		int from;
		er = options.getAsNumber( FROM, mLogValueRet );
		if( er < 0 )
			from = ScrollTransHandler.sttLeft;
		else
			from = (int) mLogValueRet[0];

		// retrieve "stay" option
		int stay;
		er = options.getAsNumber( STAY, mLogValueRet );
		if( er < 0 )
			stay = ScrollTransHandler.ststNoStay;
		else
			stay = (int) mLogValueRet[0];

		// determine maximum phase count
		int maxphase = (from == ScrollTransHandler.sttLeft || from == ScrollTransHandler.sttRight) ? src1w : src2h;

		return new ScrollTransHandler( options, layertype, time, from, stay, maxphase );
	}
}
