package jp.kirikiri.tjs2;

class SymbolData {

	static private final int
		SYMBOL_INIT = 0x2,
		SYMBOL_USING = 0x1;

	public String	mName;
	public int		mHash;
	public int		mSymFlags;
	public int		mFlags;
	public Variant	mValue;
	public SymbolData mNext;

	public void selfClear() {
		mName = null;
		mHash = 0;
		mFlags = 0;
		mValue = new Variant();
		mNext = null;
		mSymFlags = SYMBOL_INIT;
	}
	private void setNameInternal( String name ) throws TJSException {
		if( name == null ) throw new TJSException( Error.IDExpected );
		if( name.length() == 0 ) throw new TJSException( Error.IDExpected );
		if( mName != null && mName.equals(name) ) return;
		mName = new String( name );
	}
	public void setName( String name, int hash ) throws TJSException {
		setNameInternal(name);
		mHash = hash;
	}
	public final String getName() { return mName; }
	public void postClear() {
		mName = null;
		mValue = null;
		mValue = new Variant();
		mSymFlags &= ~SYMBOL_USING;
	}
	public void destory() {
		mName = null;
		mValue = null;
	}
	public boolean nameMatch( final String name ) {
		if( mName == name ) return true;
		return mName != null && mName.equals( name );
	}
	public void reShare() {
		// search shared string map using mapGlobalStringMap,
		// and ahsre the name string ( if it can )
		if( mName != null ) {
			mName = TJS.mapGlobalStringMap( mName );
		}
	}
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder(32);
		if( mName != null ) {
			builder.append(mName);
			builder.append(" : ");
		} else {
			builder.append("no name : ");
		}
		if( mValue != null ) builder.append(mValue.toString());
		else builder.append("empty");
		return builder.toString();
	}
}

