package jp.kirikiri.tvp2.env;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class CrossFadeTransHandler implements DivisibleTransHandler {
	static private final int S_OK = 0;
	static private final int S_TRUE = 1;
	static private final int S_FALSE = 2;

	protected SimpleOptionProvider mOptions;
	protected int mDestLayerType;
	protected long mStartTick;
	protected long mTime; // time during transition
	protected boolean mFirst;

	protected int mPhaseMax;
	protected int mPhase; // current phase (0 thru PhaseMax)

	public CrossFadeTransHandler( SimpleOptionProvider options, int layertype, long time ) {
		this( options, layertype, time, 255 );
	}

	public CrossFadeTransHandler(SimpleOptionProvider options, int layertype, long time, int phasemax ) {
		mDestLayerType = layertype;
		mOptions = options;
		mTime = time;
		mPhaseMax = phasemax;
		mFirst = true;
	}

	@Override
	public int setOption(SimpleOptionProvider options) {
		mOptions = null;
		mOptions = options;
		return S_OK;
	}

	@Override
	public int startProcess(long tick) {
		// notifies starting of the update
		if( mFirst ) {
			mFirst = false;
			mStartTick = tick;
		}

		// compute phase ( 0 thru 255 )
		mPhase = (int) ((tick - mStartTick ) * mPhaseMax / mTime);
		if( mPhase >= mPhaseMax ) mPhase = mPhaseMax;
		return S_TRUE;
	}

	@Override
	public int endProcess() {
		if( mPhase >= mPhaseMax ) return S_FALSE;
		return S_TRUE;
	}

	@Override
	public int process( DivisibleData data ) {
		if( mPhase == 0 ) {
			// completely source 1
			data.Dest = data.Src1;
			data.DestLeft = data.Src1Left;
			data.DestTop = data.Src1Top;
		} else if( mPhase == mPhaseMax ) {
			// completety source 2
			data.Dest = data.Src2;
			data.DestLeft = data.Src2Left;
			data.DestTop = data.Src2Top;
		} else {
			try {
				blend(data);
			} catch( Exception e ) {
				e.printStackTrace();
			}
		}
		return S_OK;
	}

	@Override
	public int makeFinalImage( ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2 ) throws TJSException {
		// final image is the source2 bitmap
		dest.copyFrom( src2 );
		return S_OK;
	}

	public void blend( DivisibleData data ) {
		BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
		BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
		BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
		int destLeft = data.DestLeft;
		int src1Left = data.Src1Left;
		int src2Left = data.Src2Left;
		int h = data.Height;
		int w = data.Width;
		int destTop = data.DestTop;
		int src1Top = data.Src1Top;
		int src2Top = data.Src2Top;

		float opa = ((float)mPhase)/255.0f;
		if( dest == src1 && destLeft == src1Left && destTop == src1Top) {
			Composite composite = AlphaComposite.getInstance( AlphaComposite.SRC_OVER, opa );
			Graphics2D g = (Graphics2D)dest.getGraphics();
			g.setComposite( composite );
			g.drawImage( src2, destLeft, destTop, destLeft+w, destTop+h, src2Left, src2Top, src2Left+w, src2Top+h, null );
			g.dispose();
		} else {
			Composite composite = AlphaComposite.getInstance( AlphaComposite.SRC_OVER, opa );
			Graphics2D g = (Graphics2D)dest.getGraphics();
			g.setComposite( AlphaComposite.Src );
			g.drawImage( src1, destLeft, destTop, destLeft+w, destTop+h, src1Left, src1Top, src1Left+w, src1Top+h, null );

			g.setComposite( composite );
			g.drawImage( src2, destLeft, destTop, destLeft+w, destTop+h, src2Left, src2Top, src2Left+w, src2Top+h, null );
			g.dispose();
		}

		/*
		if( LayerType.isTypeUsingAlpha(mDestLayerType) ) {
			if(opa > 127) opa++; // adjust for error
			int iopa = 256 - opa;
			if( destType == DataBuffer.TYPE_INT && src1Type == DataBuffer.TYPE_INT && src2Type == DataBuffer.TYPE_INT ) {
				int[] s1 = ((DataBufferInt)src1Buff).getData();
				int[] s2 = ((DataBufferInt)src2Buff).getData();
				int[] d = ((DataBufferInt)destBuff).getData();

				destTop = destTop * destW + destLeft;
				src1Top = src1Top * src1W + src1Left;
				src2Top = src2Top * src2W + src2Left;
				for( int y = 0; y < h; y++ ) {
					for( int x = 0; x < w; x++ ) {
						int s1v = s1[src1Top+x];
						int s2v = s2[src1Top+x];
						int a1 = s1v >>> 24;
						int a2 = s2v >>> 24;
						int s1t = s1v & 0xff00ff;
						s1t = ((s1t + (((s2v & 0xff00ff) - s1t) * alpha >> 8)) & 0xff00ff);
						s1v &= 0xff00;
						s2v &= 0xff00;
						s1t |= (a1 + ((a2 - a1)*opa >> 8)) << 24;
						d[destTop+x] = s1t | ((s1v + ((s2v - s1v) * alpha >> 8)) & 0xff00);
					}
					destTop += destW;
					src1Top += src1W;
					src2Top += src2W;
				}
			}
		} else if( LayerType.isTypeUsingAddAlpha(mDestLayerType) ) {
		} else {
			int destW = dest.getWidth();
			int src1W = src1.getWidth();
			int src2W = src2.getWidth();

			DataBuffer destBuff = dest.getRaster().getDataBuffer();
			final int destType = destBuff.getDataType();

			DataBuffer src1Buff = src1.getRaster().getDataBuffer();
			final int src1Type = src1Buff.getDataType();
			DataBuffer src2Buff = src2.getRaster().getDataBuffer();
			final int src2Type = src2Buff.getDataType();
			int opa = mPhase;
			if( destType == DataBuffer.TYPE_INT && src1Type == DataBuffer.TYPE_INT && src2Type == DataBuffer.TYPE_INT ) {
				int[] s1 = ((DataBufferInt)src1Buff).getData();
				int[] s2 = ((DataBufferInt)src2Buff).getData();
				int[] d = ((DataBufferInt)destBuff).getData();

				destTop = destTop * destW + destLeft;
				src1Top = src1Top * src1W + src1Left;
				src2Top = src2Top * src2W + src2Left;
				for( int y = 0; y < h; y++ ) {
					for( int x = 0; x < w; x++ ) {
						int s1v = s1[src1Top+x];
						int s2v = s2[src1Top+x];
						int s1t = s1v & 0xff00ff;
						s1t = ((s1t + (((s2v & 0xff00ff) - s1t) * opa >> 8)) & 0xff00ff);
						s1v &= 0xff00;
						s2v &= 0xff00;
						d[destTop+x] = s1t | ((s1v + ((s2v - s1v) * opa >> 8)) & 0xff00);
					}
					destTop += destW;
					src1Top += src1W;
					src2Top += src2W;
				}
			}
		}
		*/
	}
}
