package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.env.Clipboard;

public class ClipboardClass extends NativeClass {
	static public int mClassID = -1;
	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;

	static private final int
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "Clipboard";

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public ClipboardClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "hasFormat", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;
				int format = param[0].asInteger();
				boolean has = Clipboard.hasFormat(format);
				if( result != null ) result.set( has ? 1 : 0);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );


		registerNCM( "asText", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				String text = Clipboard.getText();
				if(text!=null)
					result.set( text );
				else
					result.clear();
					// returns void if the clipboard does not have a text data
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				Clipboard.setText(param.asString());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

	}

}
