package jp.kirikiri.tvp2.env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;

public class RotateSwapTransHandlerProvider implements TransHandlerProvider {

	private static final String TIME = "time";
	private static final String BGCOLOR = "bgcolor";
	private static final String TWIST = "twist";

	private Variant mVariantRet;
	protected long[] mLogValueRet;

	public RotateSwapTransHandlerProvider() {
		mVariantRet = new Variant();
		mLogValueRet = new long[1];
	}

	@Override
	public String getName() { return "rotateswap"; }

	@Override
	public BaseTransHandler startTransition(SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h, int[] type) throws TJSException {

		if( type != null && type.length >= 1 ) type[0] = ttExchange; // transition type : exchange
		if( type != null && type.length >= 2 ) type[1] = tutDivisible; // update type : divisible
			// update type : divisible fade
		if( options == null ) return null;

		if(src1w != src2w || src1h != src2h)
			Message.throwExceptionMessage( Message.TransitionLayerSizeMismatch,
				 String.valueOf(src2w) + "x" + src2h,
				 String.valueOf(src1w) + "x" + src1h );

		// オプションを得る
		// retrieve "time" option
		int er = options.getAsNumber( TIME, mLogValueRet );
		if( er < 0 ) Message.throwExceptionMessage( Message.SpecifyOption, TIME );
		long time = mLogValueRet[0];
		if( time < 2) time = 2; // あまり小さな数値を指定すると問題が起きるので

		er = options.getAsNumber( BGCOLOR, mLogValueRet );
		int bgcolor = 0;
		if( er >= 0 ) {
			bgcolor = (int) mLogValueRet[0];
		}

		er = options.getValue( TWIST, mVariantRet );
		double twist = 1.0;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			twist = mVariantRet.asDouble();
		}
		mVariantRet.clear();

		// オブジェクトを作成
		return new RotateSwapTransHandler(time, src1w, src1h, bgcolor, twist );
	}

}
