/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

public class TJSScriptError extends TJSException {

	/**
	 *
	 */
	private static final long serialVersionUID = -1727870605938357683L;

	private static final int  MAX_TRACE_TEXT_LEN = 1500;

	private SourceCodeAccessor mAccessor;
	private int mPosition;
	private String mTrace;


	public SourceCodeAccessor getAccessor() { return mAccessor; }

	public int getPosition() { return mPosition; }

	public int GetSourceLine() {
		return mAccessor.srcPosToLine(mPosition) +1;
	}

	public final String getBlockName() {
		final String name = mAccessor.getName();
		return name != null ? name : "";
	}

	public final String getTrace() { return mTrace; }

	public boolean addTrace( ScriptBlock block, int srcpos ) {
		int len = mTrace.length();
		if( len >= MAX_TRACE_TEXT_LEN) return false;

		if( len != 0 ) mTrace += " <-- ";
		mTrace += block.getLineDescriptionString(srcpos);
		return true;
	}
	public boolean addTrace( final String data ) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;
		if(len != 0) mTrace += " <-- ";
		mTrace += data;
		return true;
	}

	public TJSScriptError( final String Msg, SourceCodeAccessor accessor, int pos ) {
		super(Msg);
		mAccessor = accessor;
		mPosition = pos;
		mTrace = new String();
	}
	public TJSScriptError( final TJSScriptError ref) {
		mAccessor = ref.mAccessor;
		mPosition = ref.mPosition;
		mTrace = ref.mTrace;
	}

	public boolean addTrace(InterCodeObject context, int codepos) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;

		if(len != 0) mTrace += " <-- ";
		mTrace += context.getPositionDescriptionString(codepos);
		return true;
	}
}
