package jp.kirikiri.tvp2.utils;

public class Random {

	static private byte[] RandomSeedPool = new byte[0x1000 + 512];
	// 512 is to avoid buffer over-run posibility in multi-threaded access
	static private int RandomSeedPoolPos = 0;
	static private byte RandomSeedAtom; // need not to initialize

	static public void pushEnvironNoise( final byte[] buf ) {
		final int bufsize = buf.length;
		for( int i = 0; i < bufsize; i++ ) {
			RandomSeedPool[RandomSeedPoolPos ++] ^= (RandomSeedAtom ^= buf[i]);
			RandomSeedPoolPos &= 0xfff;
		}
		RandomSeedPoolPos += (buf[0]&1);
		RandomSeedPoolPos &= 0xfff;
	}

	static public void updateEnvironNoiseForTick() {
		long tick = System.currentTimeMillis();
		pushEnvironNoise( tick );
	}
	static public void pushEnvironNoise( long val ) {
		byte[] buf = new byte[8];
		buf[0] = (byte) ((val >> 56) & 0xFF);
		buf[1] = (byte) ((val >> 48) & 0xFF);
		buf[2] = (byte) ((val >> 40) & 0xFF);
		buf[3] = (byte) ((val >> 32) & 0xFF);
		buf[4] = (byte) ((val >> 24) & 0xFF);
		buf[5] = (byte) ((val >> 16) & 0xFF);
		buf[6] = (byte) ((val >> 8) & 0xFF);
		buf[7] = (byte) (val & 0xFF);
		Random.pushEnvironNoise( buf );
		buf = null;
	}
}

