package jp.kirikiri.tvp2.base;

import java.util.ArrayList;

import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.env.ApplicationSystem;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.Random;
import jp.kirikiri.tvp2.visual.GraphicsLoader;
import jp.kirikiri.tvp2.visual.LayerNI;

public class SystemClass extends NativeClass {
	/** Class ID */
	static public int mClassID = -1;

	static private final int
		E_BADPARAMCOUNT	= -1004,
		E_ACCESSDENYED	= -1007,
		S_OK			= 0;

	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		STATICMEMBER		= 0x00010000; // member is not registered to the
										  // object (internal use)

	/** クラス名 */
	static private final String CLASS_NAME = "System";
	static private final int nitMethod = 1, nitProperty = 2;

	protected NativeInstance createNativeInstance() throws TJSException {
		// this class cannot create an instance
		Message.throwExceptionMessage(Message.CannotCreateInstance);
		return null;
	}

	public SystemClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;


		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "terminate", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				int code = param.length > 0 ? param[0].asInteger() : 0;
				TVP.Application.terminateAsync(code);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "exit", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// this method does not return
				int code = param.length > 0 ? param[0].asInteger() : 0;
				TVP.Application.terminateSync(code);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "inputString", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 3) return E_BADPARAMCOUNT;
				String value = param[2].asString();
				String b = TVP.Application.InputQuery( param[0].asString(), param[1].asString(), value);
				if( result!=null ) {
					if( b != null )
						result.set( b );
					else
						result.clear();
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "addContinuousHandler", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// add function to continus handler list
				if( param.length < 1) return E_BADPARAMCOUNT;
				VariantClosure clo = param[0].asObjectClosure();
				TVP.EventManager.addContinuousHandler(clo);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "removeContinuousHandler", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// remove function from continuous handler list
				if( param.length < 1) return E_BADPARAMCOUNT;
				VariantClosure clo = param[0].asObjectClosure();
				TVP.EventManager.removeContinuousHandler(clo);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "toActualColor", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// convert color codes to 0xRRGGBB format.
				if( param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) {
					int color = param[0].asInteger();
					color = LayerNI.toActualColor(color);
					result.set( color );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "clearGraphicCache", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				// clear graphic cache
				GraphicsLoader.clearGraphicCache();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "touchImages", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				// try to cache graphics
				if( param.length < 1) return E_BADPARAMCOUNT;

				ArrayList<String> storages = new ArrayList<String>();
				VariantClosure array = param[0].asObjectClosure();
				int count = 0;
				Variant val = new Variant();
				while(true) {
					int hr = array.mObject.propGetByNum(0, count, val, array.mObjThis);
					if( hr < 0 )
						break;
					if(val.isVoid() ) break;
					storages.add( val.asString() );
					count++;
				}
				int limit = 0;
				long timeout = 0;
				if( param.length >= 2 && param[1].isVoid() != true ) limit = param[1].asInteger();
				if( param.length >= 3 && param[2].isVoid() != true ) timeout = param[1].asInteger();
				GraphicsLoader.touchImages(storages, limit, timeout);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "createUUID", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				// create UUID
				// return UUID string in form of "43abda37-c597-4646-a279-c27a1373af90"

				byte[] uuid = new byte[16];

				Random.getRandomBits128(uuid);

				uuid[8] &= 0x3f;
				uuid[8] |= 0x80; // override clock_seq

				uuid[6] &= 0x0f;
				uuid[6] |= 0x40; // override version

				String buf = String.format("%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
					uuid[ 0], uuid[ 1], uuid[ 2], uuid[ 3],
					uuid[ 4], uuid[ 5], uuid[ 6], uuid[ 7],
					uuid[ 8], uuid[ 9], uuid[10], uuid[11],
					uuid[12], uuid[13], uuid[14], uuid[15]);

				if( result != null ) result.set(buf);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "assignMessage", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// assign system message
				if( param.length < 2) return E_BADPARAMCOUNT;

				String id = param[0].asString();
				String msg = param[1].asString();
				boolean res = TJS.assignMessage( id, msg );
				if(result!=null) result.set( res ? 1 : 0);

				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "doCompact", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// compact memory usage
				int level = CompactEventCallbackInterface.COMPACT_LEVEL_MAX;
				if( param.length >= 1 && param[0].isVoid() != true )
					level = param[0].asInteger();
				TVP.EventManager.deliverCompactEvent(level);
				System.gc();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "inform", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// show simple message box
				if( param.length < 1) return E_BADPARAMCOUNT;
				String text = param[0].asString();
				String caption;
				if( param.length >= 2 && param[1].isVoid() != true )
					caption = param[1].asString();
				else
					caption = "Information";

				TVP.Application.showSimpleMessageBox(text, caption);

				if(result!=null) result.clear();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getTickCount", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				if( result != null ) {
					result.set( TVP.getTickCount() );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getKeyState", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;
				int code = param[0].asInteger();
				// boolean getcurrent = true;
				// if( param.length >= 2) getcurrent = param[1].asBoolean();

				boolean res = TVP.isKeyPressing(code);

				if(result!=null) result.set( res ? 1 : 0 );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "shellExecute", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;

				String target = param[0].asString();
				String execparam = null;
				if( param.length >= 2) execparam = param[1].asString();
				boolean res = ApplicationSystem.shellExecute(target, execparam);
				if(result!=null) result.set( res ? 1  : 0 );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "system", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;

				String target = param[0].asString();
				boolean res = ApplicationSystem.shellExecute(target, null);
				TVP.EventManager.deliverCompactEvent(CompactEventCallbackInterface.COMPACT_LEVEL_MAX); // this should clear all caches
				if(result!=null) result.set( res ? 1 : 0 );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "readRegValue", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;
				if( result == null ) return S_OK;
				String key = param[0].asString();
				result.set( ApplicationSystem.readRegValue(key) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getArgument", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;
				if(result==null) return S_OK;

				String name = param[0].asString();
				String res = ApplicationSystem.getProperty( name );
				result.set( res );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "setArgument", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 2) return E_BADPARAMCOUNT;
				String name = param[0].asString();
				String value = param[1].asString();
				ApplicationSystem.setProperty( name, value );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "createAppLock", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1) return E_BADPARAMCOUNT;
				if( result == null ) return S_OK;

				String lockname = param[0].asString();
				boolean res = ApplicationSystem.createAppLock(lockname);
				if(result!=null) result.set( res ? 1 : 0 );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "nullpo", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				// force make a null-po
				throw new NullPointerException();
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		// TODO 追加
		registerNCM( "confirmYesNo", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				// show simple message box
				if( param.length < 1) return E_BADPARAMCOUNT;
				String text = param[0].asString();
				String caption;
				if( param.length >= 2 && param[1].isVoid() != true )
					caption = param[1].asString();
				else
					caption = "Confirm";

				boolean ret = TVP.Application.showYesNoDialog(caption, text);

				if(result!=null) result.set(ret?1:0);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );


		registerNCM( "versionString", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.Application.getVersionString() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "versionInformation", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.Application.getVersionInformation() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "eventDisabled", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.getSystemEventDisabledState() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.setSystemEventDisabledState( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "graphicCacheLimit", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.getGraphicCacheLimit() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TVP.setGraphicCacheLimit( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "platformName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVPSystem.getPlatformName() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "osName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVPSystem.getOSName() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exitOnWindowClose", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.TerminateOnWindowClose ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.TerminateOnWindowClose = param.asBoolean();
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "drawThreadNum", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( 0 ); // 常にauto扱い
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				// 何が来ても無視
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "processorNum", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVPSystem.getProcessorNum() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exitOnNoWindowStartup", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.TerminateOnNoWindowStartup ? 1 : 0);
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.TerminateOnNoWindowStartup = param.asBoolean();
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exePath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) throws TJSException {
				result.set( ApplicationSystem.getAppPath() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "personalPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) throws TJSException {
				result.set( ApplicationSystem.getPersonalPath() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "appDataPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) throws TJSException {
				result.set( ApplicationSystem.getPersonalPath() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "dataPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DataPath );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exeName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getExeName() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "title", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.getAppTitle() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TVP.setAppTitle(param.asString());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "screenWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getScreenWidth() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "screenHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getScreenHeight() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopLeft", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getDesktopLeft() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getDesktopTop() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getDesktopWidth() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.MainForm.getDesktopHeight() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "stayOnTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				if( TVP.MainWindow != null ) {
					result.set( TVP.MainWindow.getStayOnTop() ? 1 : 0 );
				}
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				if( TVP.MainWindow != null ) {
					TVP.MainWindow.setStayOnTop( param.asBoolean() );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );


		// register default "exceptionHandler" member
		Variant val = new Variant( null, null );
		propSet( MEMBERENSURE, "exceptionHandler", val, this);

		// and onActivate, onDeactivate
		propSet( MEMBERENSURE, "onActivate", val, this);
		propSet( MEMBERENSURE, "onDeactivate", val, this);
	}
}
