package jp.kirikiri.tvp2.sound;


import java.io.IOException;
import java.nio.ByteBuffer;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.EventManager;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.env.SoundStream;
import jp.kirikiri.tvp2.msg.Message;


public class WaveSoundBufferNI extends NativeInstanceObject {

	static private final int S_OK = 0;
	static private final int E_BADPARAMCOUNT	= -1004;

	/** data is not specified */
	static public final int ssUnload = 0;
	/** stop */
	static public final int ssStop = 1;
	/** play */
	static public final int ssPlay = 2;
	/** pause */
	static public final int ssPause = 3;


	static private final String UNLOAD = "unload";
	static private final String PLAY = "play";
	static private final String STOP = "stop";
	static private final String UNKNOWN = "unknown";
	static private final String ON_STATUS_CHANGED = "onStatusChanged";

	private Dispatch2 mOwner; // owner object
	private VariantClosure mActionOwner; // object to send action
	private int mStatus; // status
	private boolean mCanDeliverEvents;
	private boolean mInFading;
	private int mTargetVolume; // distination volume
	private int mDeltaVolume; // delta volume for each interval
	private int mFadeCount; // beat count over fading
	private int mBlankLeft; // blank time until fading

	private int mVolume;
	private int mVolume2;

	private SoundStream mSoundStream;

	public WaveSoundBufferNI() {
		//mInFading = false;
		mCanDeliverEvents = true;
		//mOwner = null;
		mActionOwner = new VariantClosure(null);
		//mActionOwner.mObject = mActionOwner.mObjThis = NULL;
		//mStatus = ssUnload;

		mVolume =  100000;
		mVolume2 = 100000;
	}
	public final int construct( Variant[] param, Dispatch2 tjs_obj ) throws VariantException, TJSException {
		if( param.length < 1) return E_BADPARAMCOUNT;

		int hr = super.construct(param, tjs_obj);
		if( hr < 0 ) return hr;

		mActionOwner.set( param[0].asObjectClosure() );
		mOwner = tjs_obj;

		mSoundStream = new SoundStream(this);
		return S_OK;
	}

	public final void invalidate() throws VariantException, TJSException {

		mCanDeliverEvents = false;
		TVP.EventManager.cancelSourceEvents(mOwner);
		mOwner = null;

		mActionOwner.mObjThis = mActionOwner.mObject = null;

		super.invalidate();
		/*
		clear();
		destroySoundBuffer();
		//if(Thread) delete Thread, Thread = NULL;
		removeWaveSoundBuffer(this);
		*/
	}

	public void open(String storagename) throws TJSException {
		mSoundStream.stop();
		BinaryStream stream = Storage.createStream(storagename,BinaryStream.READ);
		try {
			mSoundStream.openFromStream( stream.getInputStream(), storagename );
			setStatus(ssStop);
		} catch (IOException e) {
			Message.throwExceptionMessage( Message.CannotLoadSound, storagename );
		}
	}

	public void play() {
		mSoundStream.play();
		setStatus(ssPlay);
	}

	public void stop() {
		mSoundStream.stop();
		if(mStatus != ssUnload) setStatus(ssStop);
	}

	public void fade(int to, int time, int delay) {
		mSoundStream.fade( to, time, delay);
		// これだと末尾がとれないので別の方法にする
	}

	public void stopFade(boolean async, boolean settargetvol) {
		// TODO 自動生成されたメソッド・スタブ

	}

	public VariantClosure getActionOwner() { return mActionOwner; }

	public boolean getLooping() {
		return mSoundStream.getLooping();
	}

	public void setLooping(boolean b) {
		mSoundStream.setLooping(b);
	}

	public boolean getPaused() {
		return mSoundStream.getPaused();
	}

	public void setPaused(boolean b) {
		mSoundStream.setPaused(b);
	}

	public int getPan() {
		return mSoundStream.getPan();
	}

	public void setPan(int v) {
		mSoundStream.setPan(v);
	}

	public int getPosition() {
		return mSoundStream.getPosition();
	}

	public void setPosition(int pos) {
		mSoundStream.setPosition(pos);
	}

	public int getSamplePosition() {
		return mSoundStream.getSamplePosition();
	}

	public void setSamplePosition(int sample) {
		mSoundStream.setSamplePosition(sample);
	}

	public int getTotalTime() {
		return mSoundStream.getTotalTime();
	}

	public int getVolume() {
		return mVolume;
	}

	public void setVolume(int v) {
		if(v < 0) v = 0;
		if(v > 100000) v = 100000;

		if(mVolume != v) {
			mVolume = v;
			setVolumeToSoundBuffer();
		}
	}

	public int getVolume2() {
		return mVolume2;
	}

	public void setVolume2(int v) {
		if(v < 0) v = 0;
		if(v > 100000) v = 100000;

		if( mVolume2 != v ) {
			mVolume2 = v;
			setVolumeToSoundBuffer();
		}
	}

	private void setVolumeToSoundBuffer() {
		int v = (mVolume / 10) * (mVolume2 / 10) / 1000;
		//v = (v / 10) * (GlobalVolume / 10) / 1000;
		mSoundStream.setVolume(v);
	}

	public void setPos(double x, double y, double z) { }
	public int getPosX() { return 0; }
	public void setPosX(double x) { }
	public double getPosY() { return 0; }
	public void setPosY(double y) { }
	public double getPosZ() { return 0; }
	public void setPosZ(double z) { }

	public String getStatusString() {
		switch( mStatus ) {
		case ssUnload:	return UNLOAD;
		case ssPlay:	return PLAY;
		case ssStop:	return STOP;
		default:		return UNKNOWN;
		}
	}
	public void setStatus( int s ) {
		if( mStatus != s) {
			mStatus = s;
			if(mOwner!=null) {
				// Cancel Previous un-delivered Events
				TVP.EventManager.cancelSourceEvents(mOwner);
				// fire
				if(mCanDeliverEvents) {
					// fire onStatusChanged event
					Variant param = new Variant(getStatusString());
					Variant[] params = {param};
					TVP.EventManager.postEvent( mOwner, mOwner, ON_STATUS_CHANGED, 0, EventManager.EPT_IMMEDIATE, params );
				}
			}
		}
	}
	public void setStatusAsync( int s ) {
		// asynchronous version of SetStatus
		// the event may not be delivered immediately.
		if( mStatus != s ) {
			mStatus = s;
			if( mCanDeliverEvents ) {
				// fire onStatusChanged event
				if( mOwner != null ) {
					Variant param = new Variant(getStatusString());
					Variant[] params = {param};
					TVP.EventManager.postEvent( mOwner, mOwner, ON_STATUS_CHANGED, 0, EventManager.EPT_POST, params );
				}
			}
		}
	}

	public int getFrequency() {
		return mSoundStream.getFrequency();
	}

	public void setFrequency(int freq) {
		mSoundStream.setFrequency(freq);
	}

	public int getGitsPerSample() {
		return mSoundStream.getGitsPerSample();
	}

	public int getChannels() {
		return mSoundStream.getChannels();
	}

	public Dispatch2 getWaveFlagsObject() {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}

	public Dispatch2 getWaveLabelsObject() {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}

	public Dispatch2 getWaveFiltersObject() {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}
}
