# encoding: UTF-8

require 'plugin/format/lib/format_plugin_warning'

#=Alteil II のユニットへのリンクを貼り付ける書式プラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: alteil.rb 362 2011-11-14 11:42:51Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Alteil_FormatPlugin

	# 2011/11/14 更新
	# 参考）https://login.alteil.jp/al2CardDB/list.php
	NAME2ID = {
		"太陽人神『アンノウン』" => "1337",
		"太陽将軍『ザガール』" => "1338",
		"聖光の大隊長『ラフィーレ』" => "1339",
		"枢機卿『メッサーラ』" => "1340",
		"奇跡の勝利" => "1341",
		"太陽王国の精鋭聖騎士" => "1342",
		"太陽王国の守備兵" => "1343",
		"太陽王国の超力兵" => "1344",
		"神秘の装甲" => "1345",
		"真教の女神官" => "1346",
		"真教の僧兵" => "1347",
		"太陽王国の弓兵" => "1348",
		"太陽王国の女剣士" => "1349",
		"兄弟の結束" => "1350",
		"月光妃『エスカティア』" => "1351",
		"月将軍『ディカール』" => "1352",
		"戦場の竜騎士『ミリア』" => "1353",
		"月側近『ファミール』" => "1354",
		"血の涙" => "1355",
		"月大公の親衛隊" => "1356",
		"月大公の戦闘部隊" => "1357",
		"死を生業にする者" => "1358",
		"狂乱" => "1359",
		"黒死騎士" => "1360",
		"美しき貴族の霊" => "1361",
		"死霊の魔女" => "1362",
		"月公国の東方剣士" => "1363",
		"月公国の女猛剣士" => "1364",
		"銃姫『ユーニ』" => "1365",
		"赤き勇者『ディラート』" => "1366",
		"銃神『B・マクラクラン』" => "1367",
		"英雄妖精『トルテ』" => "1368",
		"炎の魔人" => "1369",
		"傭兵王国の騎士" => "1370",
		"傭兵王国の女性剣士" => "1371",
		"三つ頭の竜" => "1372",
		"怒りの咆哮" => "1373",
		"傭兵王国の銃戦士" => "1374",
		"東方の流浪剣士" => "1375",
		"辺境の魔法剣士" => "1376",
		"爆熱の翼竜" => "1377",
		"竜族の息" => "1378",
		"魔導王女『アリエーテ』" => "1379",
		"暗黒神『ノゼ』" => "1380",
		"聖騎士『イベール』" => "1381",
		"魔法騎士隊長『ミレリア』" => "1382",
		"黒羽の嵐" => "1383",
		"魔法王国の魔導騎士" => "1384",
		"魔法王国の魔術師" => "1385",
		"魔法王国の魔導戦士" => "1386",
		"楽しい夢" => "1387",
		"魔法王国の人魚兵" => "1388",
		"海空で羽ばたく翼竜" => "1389",
		"魔法王国の飛行兵" => "1390",
		"魔法王国の神官戦士" => "1391",
		"酸の雨" => "1392",
		"現人邪神『エルガンディ』" => "1393",
		"因果の道標『フェルアン』" => "1394",
		"因果の門番『シュメール』" => "1395",
		"邪悪なる神官" => "1396",
		"人王『フェルラート』" => "1222",
		"月の申し子『ミフィラー』" => "1223",
		"心病騎士『エトワール』" => "1224",
		"騎士隊長『ルーミラ』" => "1225",
		"神殿騎士団5番隊" => "1226",
		"神殿騎士団6番隊" => "1227",
		"魂の絆" => "1228",
		"太陽王国の一角獣騎士" => "1229",
		"棘針体の甲殻獣" => "1230",
		"黒曜石のカーバンクル" => "1231",
		"不死鳥の雛" => "1232",
		"混沌の三銃士『アンナローゼ』" => "1233",
		"冥妃『ガイエスソウル』" => "1234",
		"勇者兵器『モルドマーク』" => "1235",
		"古き忠臣『グレイマス』" => "1236",
		"奈落の騎士" => "1237",
		"戦闘用魔法少女【暗黒型】" => "1238",
		"過剰摂取" => "1239",
		"強化兵団の少女騎士" => "1240",
		"戦闘用魔法少女【霊体型】" => "1241",
		"強化兵団の怪力兵" => "1242",
		"暗躍する魔眼" => "1243",
		"獣帝『リヴェイラ』" => "1244",
		"新たな狩人『アリサ』" => "1245",
		"猫剣聖『リト』" => "1246",
		"遺跡ハンター『ラッセル』" => "1247",
		"猫族の騎士" => "1248",
		"傭兵王国の右腕" => "1249",
		"届く声" => "1250",
		"マイコニド" => "1251",
		"赤竜国の護衛竜" => "1252",
		"爆炎の魔法使い" => "1253",
		"妖精族の伝令" => "1254",
		"書庫の遺児『ネレイス』" => "1255",
		"魔道戦士『リュウ』" => "1256",
		"暗黒神の下僕『エブリーヌ』" => "1257",
		"海賊姫『パープルレイア』" => "1258",
		"群れを束ねる翼竜" => "1259",
		"復活した鋼の弓兵" => "1260",
		"空からの援軍" => "1261",
		"人魚族の音楽家" => "1262",
		"イルカ乗りの戦士" => "1263",
		"深海の宝石" => "1264",
		"夢を広げるモノ" => "1265",
		"魔兵『ナレヴィーズ』" => "1266",
		"神の恵み『ルシア』" => "1267",
		"終末" => "1268",
		"閃光妖精『シアメール』" => "1269",
		"裁きの炎" => "1270",
		"星槍の狩猟家『アリア』" => "1271",
		"侵食" => "1272",
		"禁忌の術師『バルモア』" => "1273",
		"妖精族の戦い" => "1274",
		"世界の敵" => "1275",
		"貪りつくす巨大豚" => "1276",
		"混沌の下僕" => "1277",
		"死者の息吹" => "1278",
		"人魚族の神官" => "1279",
		"傭兵王国の殺し屋" => "1280",
		"元素の火花" => "1281",
		"太陽の姫『アリリア』" => "564",
		"名無し『アーノ』" => "442",
		"時読『ラヴェンダ』" => "104",
		"神罰修道女『シンシア』" => "270",
		"騎士隊長『ユーディ』" => "1069",
		"光の映し身" => "272",
		"獣化病/セラフ" => "109",
		"太陽王国の騎士隊長" => "215",
		"長靴を履いた猫" => "572",
		"翡翠石のカーバンクル" => "893",
		"祝福の神官戦士" => "18",
		"光の精霊" => "20",
		"巨大暴れ象" => "575",
		"光の伝説馬" => "900",
		"鈍る武器" => "455",
		"竜皇帝『ジュッズヴァー』" => "125",
		"歪みの魔女『シュメール』" => "456",
		"白銀黒狼『メティス』" => "903",
		"殺人兵器『ラ・ボォ』" => "30",
		"指揮官『ヴァイオレット×２』" => "379",
		"呪縛" => "31",
		"月公国の聖騎士" => "229",
		"死竜" => "230",
		"戦闘用魔法少女【剣士型】" => "289",
		"強襲する悪夢" => "679",
		"戦闘用魔法少女" => "41",
		"月公国の呪われた剣士" => "295",
		"戦闘用魔法少女【欠陥品】" => "296",
		"死の行軍者" => "912",
		"強制再生" => "48",
		"魔滅者『ヴォル・アグニ』" => "688",
		"魔獣兵『ラスフィール』" => "1092",
		"狂獣『ダンダーン』" => "240",
		"二刀流『桜』" => "394",
		"狩人『カサンドラ』" => "474",
		"点火" => "157",
		"一撃必殺の武術家" => "160",
		"戦いを決めた妖精" => "305",
		"身軽な傭兵王国の剣士" => "602",
		"東方の居合い剣士" => "693",
		"東方の女剣士" => "250",
		"獰猛な二足竜" => "406",
		"秘宝を見つけた発掘者" => "699",
		"亡国の女魔法剣士" => "928",
		"重力束縛" => "174",
		"人王の鍵『エメーナ』" => "1103",
		"魔法聖騎士『ディストリア』" => "177",
		"調整体『ノゼ』" => "610",
		"水の魔術師『ミスティア』" => "80",
		"人魚族の魔術師『フェティス』" => "409",
		"背後からの襲撃" => "490",
		"海底の猟師蟹" => "87",
		"魔法王国の魔法騎士" => "258",
		"魔法王国の上級剣士" => "493",
		"深海の魔王" => "1108",
		"燕の偵察兵" => "193",
		"空杖使いの魔法使い" => "323",
		"人魚族の人化剣士" => "715",
		"暴風魔術師" => "1112",
		"水の柱" => "421",
		"竜皇帝『リティル』" => "100",
		"聖域の守護者『メイリーン』" => "103",
		"光の弓『フィスターア』" => "659",
		"聖光の剣士『ラフィーレ』" => "5",
		"少女神官" => "453",
		"月大公『エスカティア』" => "26",
		"黒竜の騎士『ミリア』" => "127",
		"獣化病/エキドウナ" => "463",
		"竜皇帝『アルィンド』" => "150",
		"少女銃使い『ユーニ』" => "153",
		"妖精騎士『トルテ』" => "691",
		"傭兵王国の魔法使い" => "403",
		"妖精族の二刀剣士" => "700",
		"竜皇帝『レグライ』" => "175",
		"人魚姫『エメーナ』" => "408",
		"氷の魔術師『ラスアム』" => "410",
		"失敗" => "199",
		"歪みの魔女と黒猫" => "947",
		"獅子男爵『ザガール』" => "4",
		"混沌の美女『アンナローゼ』" => "28",
		"魔法剣の二刀戦士" => "58",
		"風魔人" => "86",
		"魔法王国の衛兵" => "91",
		"伝説の勇者『カティラ』" => "562",
		"エル・ディアブロ" => "1320",
		"エル・ドラード" => "1321",
		"犬闘士フェンリル" => "1322",
		"レディ・アマリリス" => "1323",
		"導きの杖ホリプパ" => "1324",
		"カタストロフ・ドラゴン" => "1325",
		"エビブラック" => "1326",
		"海底牧場の魔女" => "1327",
		"銀陽帝『フェルラート』" => "1605",
		"神の叛逆者『レスター』" => "1606",
		"守護騎士団長『ダリアス』" => "1607",
		"旅する神徒『アリウス』" => "1608",
		"奇跡の衝撃" => "1609",
		"太陽王国の大盾兵" => "1610",
		"太陽王国の超力防御兵" => "1611",
		"獅子頭の大剣使い" => "1612",
		"強引な命令" => "1613",
		"真教の修道女" => "1614",
		"真教の重装騎士" => "1615",
		"太陽王国の超力移動兵" => "1616",
		"奇跡の光" => "1617",
		"月大公『ミュロンド』" => "1618",
		"月将軍『ユーグ』" => "1619",
		"汚れの宿『ガリィス』" => "1620",
		"鬼将『ガンダー』" => "1621",
		"凄惨な光景" => "1622",
		"月公国の諜報部隊" => "1623",
		"月公国の影魔術師" => "1624",
		"罰獄の騎士" => "1625",
		"仮初めの魂" => "1626",
		"戦闘用魔法少女【参謀型】" => "1627",
		"起きあがった死体" => "1628",
		"沼地の呪術師" => "1629",
		"闇からの啓示" => "1630",
		"運命妖精『ティエリエ』" => "1631",
		"受け継がれし盾『ハルミラ』" => "1632",
		"受け継がれし剣『ロズリー』" => "1633",
		"復讐の誓い『アンリエッタ』" => "1634",
		"煉獄" => "1635",
		"東方の鎧武者" => "1636",
		"傭兵王国の銃槍兵" => "1637",
		"東方の暗殺者" => "1638",
		"待ち伏せ" => "1639",
		"小鬼の兵士" => "1640",
		"傭兵王国の速射兵士" => "1641",
		"直立の歯車槍兵" => "1642",
		"信念のもとに" => "1643",
		"剛の聖騎士『リジア』" => "1644",
		"魔法探偵『ダニエル』" => "1645",
		"大虹竜『ルーテウム』" => "1646",
		"運命の子『ラミア』" => "1647",
		"軍師の機転" => "1648",
		"博識の少年" => "1649",
		"魔法王国の呪印剣士" => "1650",
		"南方の鰐騎士" => "1651",
		"惑わしの羅針盤" => "1652",
		"魔法王国の鳥使い" => "1653",
		"機械蝙蝠" => "1654",
		"魔法王国の風使い" => "1655",
		"魔術師の理想郷" => "1656",
		"烈火獄炎『バンデール』" => "1657",
		"呪将『鳳仙』" => "1658",
		"嘲りの腕『ネフテム』" => "1659",
		"大宣教師『オスレイ』" => "1660",
		"太陽王国の超力発火兵" => "1661",
		"小鬼の魔術師" => "1662",
		"藍玉のカーバンクル" => "1663",
		"火を吹く半魚人" => "1664",
		"啓示を受けた者『ラステ』" => "1675",
		"真教兵長『グラヴァーン』EX" => "1676",
		"墓場の使用人『コーネリア』" => "1677",
		"混沌の三銃士『ノゼ』EX" => "1678",
		"花園の女王『ナターシャ』" => "1679",
		"踊り子『クリナ』EX" => "1680",
		"七代目当主『アリアドネー』" => "1681",
		"書庫の契約者『バネット』EX" => "1682",
		"真光の剣士『イシュタル』" => "1684",
		"銀陽の影『カイル』" => "1685",
		"真眼の姫『リーゼス』" => "1686",
		"覇鎧兵『ベルドーサ』" => "1687",
		"同盟条約" => "1688",
		"太陽王国の超力剣士" => "1689",
		"イシュタルの神殿騎士" => "1690",
		"南方の蛇戦士" => "1691",
		"信仰心" => "1692",
		"平和の担い手" => "1693",
		"真教の黄金騎士" => "1694",
		"訓練された戦闘犬" => "1695",
		"突然の占領" => "1696",
		"完全不死『デュランダル』" => "1697",
		"滅亡の杯『リリエラ』" => "1698",
		"毒師『レシオ』" => "1699",
		"輪廻を廻る者『レナ』" => "1700",
		"死者の饗宴" => "1701",
		"獣化病/ベルゼバブ" => "1702",
		"月公国の退魔師" => "1703",
		"戦闘用魔法少女【騎士型】" => "1704",
		"闇からの短剣" => "1705",
		"月公国の黒騎兵" => "1706",
		"影の戦士" => "1707",
		"死の鷹" => "1708",
		"破られた書物" => "1709",
		"業炎の勇者『バルハート』" => "1710",
		"介入者『コンスタンツ』" => "1711",
		"衝撃の将軍『ダネス』" => "1712",
		"核熱の女王『ソル』" => "1713",
		"天変地異" => "1714",
		"東方の仕置人" => "1715",
		"牛頭の斧兵士" => "1716",
		"炎トカゲ" => "1717",
		"野生" => "1718",
		"放浪の銃戦士" => "1719",
		"暗殺の歯車人形" => "1720",
		"放浪の双剣士" => "1721",
		"妖精のいたずら" => "1722",
		"雷撃の聖騎士『ルドルフ』" => "1723",
		"魔法刀士『システィーナ』" => "1724",
		"薬剤師『エミル』" => "1725",
		"魔槍の支配者『アンリ』" => "1726",
		"水の鎧" => "1727",
		"双頭の蜥蜴兵" => "1728",
		"魔法王国の用心棒" => "1729",
		"魔法王国の天空騎士" => "1730",
		"犯人は君だ" => "1731",
		"狙撃する海賊兵" => "1732",
		"魔法王国の占い師" => "1733",
		"機械宿借" => "1734",
		"奇跡の旋律" => "1735",
		"仮面の魔女『ルピナス』" => "1736",
		"修羅鬼『フォルディア』" => "1737",
		"真っ黒な女『メルディタ』" => "1738",
		"超力兵『ハルシオン』" => "1739",
		"氷竜" => "1740",
		"妖精族の元素魔術師" => "1741",
		"汚水荒らし" => "1742",
		"黄泉からの復讐者" => "1743",
		"使者『ヴァイスフォーゲル』" => "200",
		"紅の大将『ルビーイーター』" => "548",
		"赤竜の神官『コレット』" => "629",
		"太陽の暴君『ギルエンサ』" => "644",
		"使者『ノワールヴァイデ』" => "202",
		"黒の戦乙女『アイギナ』" => "550",
		"黒竜の暗殺者『ミュルナ』" => "631",
		"仮面の悪魔『フォルフェナク』" => "646",
		"使者『ルージュエーステ』" => "204",
		"憎しみの炎『デュラン』" => "552",
		"銀殻竜の剣士『ダイソン』" => "633",
		"怪人『ベルティアー』" => "648",
		"使者『ブルーリジット』" => "206",
		"操空師『フォミュナ』" => "554",
		"蒼竜の魔術師『ミルドレオ』" => "635",
		"聖剣『フォヴォンツア』" => "650",
		"集団の暗殺者たち" => "341",
		"炎の拳" => "328",
		"黒のマント『ジャクレス』" => "718",
		"白覇王『エドゥアルト』" => "1860",
		"一撃涅槃『ミリエス』" => "1861",
		"白覇王の騎士『アルマ』" => "1862",
		"大神官『ラウリア』" => "1863",
		"奇跡の術師『ロザンナ』" => "1864",
		"邪眼" => "1865",
		"陽光の騎士" => "1866",
		"太陽王国の心眼剣士" => "1867",
		"真教の特務騎士" => "1868",
		"聖騎士の埋葬" => "1869",
		"虹石のカーバンクル" => "1870",
		"人造人間[Type:シルバー]" => "1871",
		"太陽王国の聖槌騎士" => "1872",
		"光の剣" => "1873",
		"冥将軍『オニキス』" => "1874",
		"冥将軍『エムファル』" => "1875",
		"闇月『ノーブレス』" => "1876",
		"絶望の騎士『リファーラ』" => "1877",
		"恐怖の騎士『マリエナト』" => "1878",
		"死の指先" => "1879",
		"月大公の漆黒剣士" => "1880",
		"戦闘用魔法少女【魔炉型】" => "1881",
		"獣化病 / ケルべロス" => "1882",
		"盗賊の集会" => "1883",
		"死の国の屍術士" => "1884",
		"戦闘用魔法少女【風使型】" => "1885",
		"食屍鬼の剣士" => "1886",
		"冥将軍の儀式" => "1887",
		"純血の戦乙女『キリー』" => "1888",
		"大嵐を呼ぶ魔姫『イベリア』" => "1889",
		"紅蓮の舞姫『エスターシャ』" => "1890",
		"女盗賊『レダ』" => "1891",
		"蛇髪の末娘『カニーリ』" => "1892",
		"炎の槍" => "1893",
		"傭兵王国の密偵" => "1894",
		"歯車の修羅戦士" => "1895",
		"傭兵王国の炎術使い" => "1896",
		"東方の覚悟" => "1897",
		"辺境の祈祷師" => "1898",
		"炎ミミズク" => "1899",
		"狐頭の殺し屋" => "1900",
		"鬼族の力比べ" => "1901",
		"機動装甲『ヴァルカイザー』" => "1902",
		"魔大導師『バルリア』" => "1903",
		"天道四衆『イーグレット』" => "1904",
		"鋼の副長『ダイダロス』" => "1905",
		"天道四衆『リミッテ』" => "1906",
		"瞬間移動" => "1907",
		"魔法王国の女性馬騎士" => "1908",
		"風を運ぶ妖精" => "1909",
		"水使いの魔法剣士" => "1910",
		"魔術の暗記" => "1911",
		"偏光魔術師" => "1912",
		"魔術候補生" => "1913",
		"魔法王国の遊撃騎士" => "1914",
		"氷のつぶて" => "1915",
		"不死鳥の降臨" => "1916",
		"魔女たちの宴" => "1917",
		"大鬼の戦士" => "1918",
		"彷徨える悪意" => "1919",
		"夢幻『ロウワン』" => "1946",
		"騎士隊長『イレース』EX" => "1947",
		"常夜『バルバラ』" => "1948",
		"近衛兵長『アフェエミナ』EX" => "1949",
		"獄炎『デスラスタ』" => "1950",
		"旅する猛獣『アスート』EX" => "1951",
		"妖蛇『アルロイ』" => "1952",
		"魔法兵長『トリフェ』EX" => "1953",
		"リュミエール" => "558",
		"マリア" => "559",
		"シオン" => "560",
		"ユリナ" => "561",
		"ナンナ・ミレナス" => "1961",
		"ジャナド" => "1962",
		"バイスキュア" => "1963",
		"エスカーダスーツ" => "1964",
		"医術研究生『ニコル』" => "2009",
		"光の娘『ネリッサ』" => "2010",
		"探求者『デイカー・バズ』" => "2011",
		"戦慄の娘『フラマシュ』" => "2012",
		"暴弓『クリスティ』" => "2013",
		"魔物召喚士『ニーロ』" => "2014",
		"見習い鳥使い『レイテ』" => "2015",
		"護り手『リン』" => "2016",
		"魔神竜『ヴィーラア』" => "2031",
		"守護剣士『カイラ』" => "2032",
		"神竜の巫女『イリア』" => "2033",
		"断行者『フラウ・ロウ』" => "2034",
		"執行騎士『ライバード』" => "2035",
		"魂の封印" => "2036",
		"眠れるモノ" => "2037",
		"太陽王国の超力分身兵" => "2038",
		"風信子石のカーバンクル" => "2039",
		"光化" => "2040",
		"太陽王国の聖戦士" => "2041",
		"断罪する女神官戦士" => "2042",
		"太陽王国の見習い騎士" => "2043",
		"祝福の歌" => "2044",
		"邪霊竜『ナ・イグナ・グド』" => "2045",
		"霊竜の巫女『ハイリ』" => "2046",
		"冥将軍『カルドリア』" => "2047",
		"闇の隠し子『メリル』" => "2048",
		"守護騎士『カルラ』" => "2049",
		"悪鬼の紋様" => "2050",
		"獣化病 / テュポーン" => "2051",
		"戦闘用魔法少女【対竜型】" => "2052",
		"影の小人" => "2053",
		"暗闇の覆い" => "2054",
		"死体の大巨人" => "2055",
		"月公国の恐怖騎士" => "2056",
		"放浪の魔法商人" => "2057",
		"腐食の霊気" => "2058",
		"禍の運び手『ラーニ』" => "2059",
		"灼熱の爆熱闘士『ドゥイッジ』" => "2060",
		"熟慮断行『アジャール』" => "2061",
		"赤炎の悪漢『ラキシド』" => "2062",
		"賢者妖精『ペイングリン』" => "2063",
		"大地の巨拳" => "2064",
		"南方の鳥女" => "2065",
		"彼方からの巨人" => "2066",
		"幸運を呼ぶ妖精" => "2067",
		"炎の壁" => "2068",
		"東方の弓武者" => "2069",
		"精霊と語る女剣士" => "2070",
		"遺跡の発掘者" => "2071",
		"小さな稲妻" => "2072",
		"破の聖騎士『ロイツ』" => "2073",
		"天道四衆『ゼンテ』" => "2074",
		"魔法教師『エナ・ジェリン』" => "2075",
		"碧玉の魔法戦士『リレイ』" => "2076",
		"晶騎士長『ナイア』" => "2077",
		"鋼の封印" => "2078",
		"魔法王国の改造兵" => "2079",
		"魔法王国の晶槍士" => "2080",
		"機械蛇" => "2081",
		"水霊の加護" => "2082",
		"魔法王国の雷弓兵" => "2083",
		"魔法王国の晶騎士" => "2084",
		"魔法王国の霧魔術師" => "2085",
		"精神の集中" => "2086",
		"魔術の忌み子" => "2087",
		"火閃の魔法剣士" => "2088",
		"月公国の黒炎使い" => "2089",
		"竜殺しの矢" => "2090",
		"剛勇無謀『ヘルキュレイス』" => "2103",
		"愛すべき毒と呪『ロゼッタ』" => "2104",
		"武帝『カンユウ』" => "2105",
		"探求と狂知『アルベルト』" => "2106",
		"天駆ける聖女『バルフレイス』" => "2117",
		"太陽王国の超力防御兵EX" => "2118",
		"放浪せし者『スケーニカ』" => "2119",
		"月公国の諜報部隊EX" => "2120",
		"魔刀の完成者『ナナクサ』" => "2121",
		"傭兵王国の銃戦士EX" => "2122",
		"魔導結界『アイヴラー』" => "2123",
		"魔法王国の魔導戦士EX" => "2124",
		"神官隊長『パトリシア』" => "2179",
		"神殿隊長『リリアナ』" => "2180",
		"白のツルギ『ニール』" => "2181",
		"聖なる拳『ルダート』" => "2182",
		"神童『ラティヌス』" => "2183",
		"蘇生の炎" => "2184",
		"人造人間[Type:ゴールド]" => "2185",
		"人造人間[Type:プラチナ]" => "2186",
		"人造人間[Type:クリスタル]" => "2187",
		"生命の雨" => "2188",
		"伝説を従える神官" => "2189",
		"真教の諜報員" => "2190",
		"少年格闘家" => "2191",
		"光の儀式" => "2192",
		"聖魔竜『ジュベレーゼ』" => "2193",
		"冥将軍『フォルス』" => "2194",
		"残忍なる不浄『ユディット』" => "2195",
		"盟主『マティース』" => "2196",
		"盟主『フォックス』" => "2197",
		"冥府の呼び手" => "2198",
		"漆黒の刃" => "2199",
		"獣化病/オセ" => "2200",
		"暗闇の暗殺者" => "2201",
		"後悔の念" => "2202",
		"闇の使い魔" => "2203",
		"月公国の弓兵" => "2204",
		"月公国の盾兵" => "2205",
		"断罪の時" => "2206",
		"盲虎王『ダルダルト』" => "2207",
		"覇弓『メリアーヌ』" => "2208",
		"狩人『スティリア』" => "2209",
		"赤蛇『ステバーン』" => "2210",
		"守護蛇の次女『リンダ』" => "2211",
		"巨竜襲撃" => "2212",
		"異形の多足女戦士" => "2213",
		"歴戦の河馬勇士" => "2214",
		"博識の水牛術師" => "2215",
		"鎧徹し" => "2216",
		"秘境に住む女戦士" => "2217",
		"竜鎧の戦士" => "2218",
		"彷徨える銃戦士" => "2219",
		"地脈の力" => "2220",
		"封印竜族『ミスティーグ』" => "2221",
		"魔女『アレクザンドラ』" => "2222",
		"東方からの刺客『ハヤト』" => "2223",
		"破魔の副官『ディロイ』" => "2224",
		"第二月『ユーリア』" => "2225",
		"氷の十字架" => "2226",
		"魔法王国の晶弓騎士" => "2227",
		"古代呪札の魔術師" => "2228",
		"伝承の杖術師" => "2229",
		"集団飛行" => "2230",
		"白魔術書の読み手" => "2231",
		"異界に潜む魔術師" => "2232",
		"黒魔術書の読み手" => "2233",
		"水の鏡" => "2234",
		"響天動地" => "2235",
		"楽園の儀式" => "2236",
		"雄の意地" => "2237",
		"永久凍結" => "2238",
		"ピースブリンガーエンジェル" => "2244",
		"デスブリンガー・エンジェル" => "2245",
		"神滅侯爵ラインハルト" => "2246",
		"時空を歪める者シュレーゲル" => "2247",
		"調停商人オウル・カーン" => "2248",
		"魂の刃マキリ" => "2249",
		"フルアーマー韋駄天丸" => "2250",
		"組合長ペンギン・ポー" => "2251",
		"サイバー・プリンス" => "2252",
		"サイバー・ビューティー" => "2253",
		"清き乙女剣士『メルファリス』" => "2263",
		"騎士隊長『ルーミラ』EX" => "2264",
		"黒き正義『フォセル』" => "2265",
		"左の盾『カファール』EX" => "2266",
		"暴走竜『バルフィラ』" => "2267",
		"炎の嵐『バンデール』EX" => "2268",
		"清き舞姫『ファナナス』" => "2269",
		"玄武の軍師『ラドル』EX" => "2270",
		"白導師『カルドラオ』" => "772",
		"観測者『ルリア』" => "773",
		"最強の銃『J・ウィンストン』" => "774",
		"魔封士『ミカーシャ』" => "775",
		"救世聖人『アギオス』" => "2281",
		"天竜の乙女『イリア』" => "2282",
		"罰を断ち切る者『フリード』" => "2283",
		"守護騎士『エリザベート』" => "2284",
		"祝福の短剣『マリアナ』" => "2285",
		"超力を操る白騎士" => "2286",
		"聖獣/スレイプス" => "2287",
		"太陽王国の白銀騎士" => "2288",
		"天からの光" => "2289",
		"聖人の守護騎士" => "2290",
		"聖なる転生鳥" => "2291",
		"戦花の一撃" => "2292",
		"開放されし目" => "2293",
		"現世魔王『シメオン』" => "2294",
		"失敗兵『ナレヴィーズ』" => "2295",
		"幽玄妖精『イングリト』" => "2296",
		"黒騎士『ウィリディタス』" => "2297",
		"微笑の軍師『アイヴィ』" => "2298",
		"漆黒の魔術師" => "2299",
		"漆黒の騎士" => "2300",
		"邪気の死霊" => "2301",
		"報復の鉄処女" => "2302",
		"暗黒の妖精" => "2303",
		"戦闘用魔法少女【催眠型】" => "2304",
		"邪悪な占い" => "2305",
		"悪寒の正体" => "2306",
		"覇界王『ルチアーナ』" => "2307",
		"剣魔支配『刀喰』" => "2308",
		"勇者の直系『ダリアン』" => "2309",
		"銀牙『ウォルフェン』" => "2310",
		"盲目の女剣士『フィーリアス』" => "2311",
		"南蛮族の戦士" => "2312",
		"流れの聖騎士" => "2313",
		"溶岩の巨人" => "2314",
		"赤い大雷" => "2315",
		"火炎の翼竜" => "2316",
		"東方の悪魔払い" => "2317",
		"強襲作戦" => "2318",
		"竜殺しの一太刀" => "2319",
		"魔導王『ヘルヴォージ』" => "2320",
		"黒導師『デモンズ』" => "2321",
		"魔導聖女『レギーナ』" => "2322",
		"喪失者『アスベル』" => "2323",
		"天道四衆『ニドル』" => "2324",
		"水晶の馬騎士" => "2325",
		"破魔の黒術師" => "2326",
		"霧魔法の剣士" => "2327",
		"怒りの雷" => "2328",
		"水晶の魔法騎士" => "2329",
		"支配された翼竜" => "2330",
		"魔法のトビラ" => "2331",
		"奪われる魔法" => "2332",
		"飛竜騎士『アンヴィル』" => "2333",
		"魔法神官『ルイーサ』" => "2334",
		"放浪の魔剣士『ヴァシリキ』" => "2335",
		"異説『D・ウィンストン』" => "2336",
		"太陽獣の死騎士" => "2337",
		"呪の魔人形" => "2338",
		"豪快なる女海賊" => "2339",
		"失魔法の詠唱者" => "2340",
		"コロナマスター・エンジェル" => "2346",
		"ミラーコーティング・ペガサス" => "2347",
		"華麗なる人形遣いコルヴィッツ" => "2348",
		"魔獣軍団長ヴァサーゴ" => "2349",
		"神を討つ魔剣の勇者" => "2350",
		"融解戦鬼灼熱王" => "2351",
		"ＩＳＥ・エビブラック" => "2352",
		"ジャック・オー・フロスト" => "2353",
		"採掘工アリサ" => "2354",
		"美麗羊ビューティ・ラム" => "2355",
		"レディ・ラスト" => "2356",
		"声をひそめる人形レイラ" => "2357",
		"アニヒレイト・ドラゴン" => "2358",
		"祭儀の踊り子リムセ" => "2359",
		"恵みの雨の魔女" => "2360",
		"悪戯するフェアリー" => "2361",
		"神罰修道女『クラリッサ』" => "2388",
		"破壊神官『ランドルフ』" => "2389",
		"聖なる輝き" => "2390",
		"吸血魔女『ネリア』" => "2391",
		"キノコの化身『ソウキ』" => "2392",
		"荒王『エクスプグナティオ』" => "2393",
		"東方の戦巫女『狭霧』" => "2394",
		"未来視『シリーン』" => "2395",
		"神の審判『レギナ』" => "2409",
		"薬神『フローレンス』" => "2410",
		"十二剣の狂王『カリバーン』" => "2411",
		"沈黙の道化『ガンプ』" => "2412",
		"博愛の憤鎚『ロディタ』" => "2415",
		"初代教皇『アベル』EX" => "2416",
		"修羅の母心『カーリ』" => "2417",
		"殺人兵器『ラ・ボォ』EX" => "2418",
		"微風なる英傑『アンダース』" => "2419",
		"神槍『エストマ』EX" => "2420",
		"魔装甲士『アトロポリス』" => "2421",
		"海賊王『ダヴリッド』EX" => "2422",
		"機械神『アルベルティーネ』" => "2436",
		"神解師『グレーテル』" => "2437",
		"機械竜『アグスティン』" => "2438",
		"投石隊長『イサドラ』" => "2439",
		"守護の大盾『ヴィタリ』" => "2440",
		"救世主の聖騎士" => "2441",
		"救世主の理力騎士" => "2442",
		"リリアナの神殿騎士" => "2443",
		"神人の一撃" => "2444",
		"救世主の神罰剣士" => "2445",
		"太陽王国の洗練剣士" => "2446",
		"救世主の地上竜騎士" => "2447",
		"太陽の号令" => "2448",
		"大魔王『ジーグルト』" => "2449",
		"神解師『ドミナ』" => "2450",
		"仮面の剣士『エレウエ』" => "2451",
		"滴る血『オーレリアーノ』" => "2452",
		"破壊兵『ガンガドライ』" => "2453",
		"魔王の騎士" => "2454",
		"魔王の漆黒騎士" => "2455",
		"死霊の妖精" => "2456",
		"死の剣" => "2457",
		"魔王の魔女" => "2458",
		"魔王の神殿騎士" => "2459",
		"戦闘用魔法少女【海賊型】" => "2460",
		"真夜中の進軍" => "2461",
		"猫軍師『パリュール』" => "2462",
		"蜥蜴呪師『ガーリッシュ』" => "2463",
		"蜥蜴騎士『エルモスーラ』" => "2464",
		"猫従者『マズルカ』" => "2465",
		"百の剣『セイオウマル』" => "2466",
		"南蛮族の強襲部隊" => "2467",
		"疾走する戦闘馬車" => "2468",
		"東方の長刀剣士" => "2469",
		"南蛮族の大決起" => "2470",
		"南蛮族の魔法剣士" => "2471",
		"南蛮族の攻城兵器" => "2472",
		"烏の魔術師" => "2473",
		"立ちあがる傭兵たち" => "2474",
		"海賊王『ヴェンツェル』" => "2475",
		"狂おしい聖歌『グエンドリン』" => "2476",
		"青き海軍『ローラント』" => "2477",
		"残虐海獣『ウルバノ』" => "2478",
		"青き虐殺者『アウドラ』" => "2479",
		"二丁拳銃の海賊" => "2480",
		"深海の海甲羅竜" => "2481",
		"死の暗黒馬騎士" => "2482",
		"水の蛇" => "2483",
		"蛮勇なる海賊" => "2484",
		"青き船の魔騎士" => "2485",
		"統一された人面鳥" => "2486",
		"突如出現" => "2487",
		"冥府の船『アウレーリエ』" => "2488",
		"剣の白鳥『マリヤッタ』" => "2489",
		"邪と正義感『エグランタイン』" => "2490",
		"異界の槍『フィロメナ』" => "2491",
		"呪の魔剣士" => "2492",
		"あらくれ船長" => "2493",
		"白き呪の暗殺者" => "2494",
		"無念なる少女" => "2495",
		"狂信美貌『エチ』" => "2500",
		"白麗黒心『クミホ』" => "2501",
		"人狩地王『ウィルタ』" => "2502",
		"沈黙破軍『アドミラル』" => "2503",
		"ネコ機甲" => "2508",
		"メイドのラブ" => "2509",
		"ロリー" => "2510",
		"フローラ" => "2511",
		"永遠なる使用人『ソーヴィ』" => "2529",
		"王の守護者EX" => "2530",
		"鬼気の主『ユリアーネ』" => "2531",
		"死者の騎士EX" => "2532",
		"白毛覇『ナンナ』" => "2533",
		"妖精族の暗殺者EX" => "2534",
		"風舞装師『アルキス』" => "2535",
		"呪印を使う槍兵EX" => "2536",
		"神託麗人『アリアンヌ』" => "2546",
		"花騎士団『イライア』" => "2547",
		"鵺将『アルヌール』" => "2548",
		"陽光の翼『リュリュ』" => "2549",
		"封の天才『ミルッカ』" => "2550",
		"救世有情の構え" => "2551",
		"救世主の槌罰兵" => "2552",
		"守護騎士団の槍兵" => "2553",
		"奇跡の母神祝福" => "2554",
		"救世主の保健兵" => "2555",
		"暴れる大斧兵" => "2556",
		"救世主の神罰騎士" => "2557",
		"鬼竜姫『イザベラ』" => "2558",
		"弐腕『エイティピカル』" => "2559",
		"金銀狐『ロザリンド』" => "2560",
		"参腕『モドラーリー』" => "2561",
		"黒迅槍『オノリーヌ』" => "2562",
		"黒森の血まみれ牙" => "2563",
		"戦闘用魔法少女【呪書型】" => "2564",
		"月公国の野性戦士" => "2565",
		"べっとりな罪悪感" => "2566",
		"魔王の軽装騎士" => "2567",
		"魔王の天罰僧侶" => "2568",
		"満月の眷族" => "2569",
		"滅神の棺『エンデ』" => "2570",
		"竜操蜥蜴『ディサフィーオ』" => "2571",
		"轟怒角『エクロズィオン』" => "2572",
		"灼炎赤槍『ユウライ』" => "2573",
		"豚王の忘れ形見『リーナ』" => "2574",
		"悪趣味な陰湿炎" => "2575",
		"地気をえる格闘家" => "2576",
		"剛胆なる大亀族" => "2577",
		"暴風岩" => "2578",
		"南蛮族の夜猫忍者" => "2579",
		"異形なる鬼人侍" => "2580",
		"雄叫びなる猪族" => "2581",
		"把握せし者『アエシュマ』" => "2582",
		"狂騒装甲『ヴァルイヴィール』" => "2583",
		"熱血小身『マーガレッタ』" => "2584",
		"研究鬼『ホーキポーキィ』" => "2585",
		"略奪王『アルデュイノ』" => "2586",
		"死呼ぶ突然の凪" => "2587",
		"楽天的な狂機械工作員" => "2588",
		"極寒の氷結魔" => "2589",
		"極楽浄土の呪船" => "2590",
		"略奪王の女剣士" => "2591",
		"海賊王の襲撃兵士" => "2592",
		"瘴気鎧の騎士" => "2593",
		"竜眼妹『グラフヴェルズ』" => "2594",
		"駆ける聖馬『ヴィルホ』" => "2595",
		"神聖天臨『クリーン』" => "2596",
		"灼迅相槍『アトラクト』" => "2597",
		"魂魄変換の魔鎧兵" => "2598",
		"妖精族の戦闘騎士" => "2599",
		"忌々しい魔導王の気" => "2600",
		"小さき宝石獣" => "2601",
		"大魔王の忌炎" => "2602",
		"死船の花嫁" => "2603",
		"南蛮族の術剣使い" => "2604",
		"妖精族の祈祷師" => "2605",
		"破滅神官『ラウリア』" => "2641",
		"一撃涅槃『ミリエス』EX" => "2642",
		"迫る恐怖と訪れた絶望" => "2643",
		"滅亡の杯『リリエラ』EX" => "2644",
		"受継ぐ者『ロズリー』" => "2645",
		"賢者妖精『ペイングリン』EX" => "2646",
		"暴走娘と寡黙な剣" => "2647",
		"東方からの刺客『ハヤト』EX" => "2648",
		"大隊長『イシュタル』" => "2650",
		"昇天の使徒『マリリン』" => "2651",
		"枢機卿『マルチェロ』" => "2652",
		"奇跡を唄うモノ『シャル』" => "2653",
		"守護者『白虎』" => "2654",
		"偽りの神託" => "2655",
		"黒薔薇の騎士" => "2656",
		"太陽王国の銃騎士" => "2657",
		"祭壇を背負う神官" => "2658",
		"信仰による覚醒" => "2659",
		"太陽王国の神殺部隊" => "2660",
		"聖獣/パピルサグ" => "2661",
		"白薔薇の騎士" => "2662",
		"逆十字を持つ兵士" => "2663",
		"致死への道程『ドロシー』" => "2664",
		"断罪スル者『ヤマラージャ』" => "2665",
		"創世の主『シェリーヌ』" => "2666",
		"守護者『玄武』" => "2667",
		"案内人『ディーナ』" => "2668",
		"黄泉を渡る大扉" => "2669",
		"月公国の人狩り部隊" => "2670",
		"戦闘用魔法少女【覚醒型】" => "2671",
		"月夜に潜む殺意" => "2672",
		"大魔王の最後" => "2673",
		"死を売り歩く商人" => "2674",
		"双頭の蛇" => "2675",
		"戦闘用魔法少女【充電型】" => "2676",
		"地中より現れる工作兵" => "2677",
		"王者の御印『バルベル』" => "2678",
		"主様の懐刀『アヤメ』" => "2679",
		"双国の絆『ジャスティン』" => "2680",
		"守護者『朱雀』" => "2681",
		"一閃千斬『タケゾウ』" => "2682",
		"エンデの本気" => "2683",
		"傭兵王国の精鋭騎士" => "2684",
		"荒ぶる野武士" => "2685",
		"傭兵王国の砲兵" => "2686",
		"最新鋭の戦術" => "2687",
		"古の地面竜" => "2688",
		"トリフィド" => "2689",
		"傭兵王国の罠師" => "2690",
		"見習い砲兵" => "2691",
		"最終機甲『ヴァルノワール』" => "2692",
		"雨魔導師『プリシア』" => "2693",
		"覚醒兵器『スクワイア』" => "2694",
		"光魔導師『アンジェ』" => "2695",
		"守護者『青竜』" => "2696",
		"ヴァル・ブラスター" => "2697",
		"魔法王国の機械武器兵" => "2698",
		"絶対零度の凶刃" => "2699",
		"陽気に歌う女海賊" => "2700",
		"ヴェンツェルの愛" => "2701",
		"呪印を持つ双剣使い" => "2702",
		"魔法王国の一角騎士" => "2703",
		"氷結の刃" => "2704",
		"燕の弓兵" => "2705",
		"断罪の剣『プロディジャス』" => "2706",
		"主様の隠刀『キキョウ』" => "2707",
		"赤き熱風『サンタナ』" => "2708",
		"潜むモノ『リピーロ』" => "2709",
		"豊穣を祈る乙女『リコルッテ』" => "2732",
		"東方の騎士『トロメア』EX" => "2733",
		"機巧乙女『篝火』" => "2734",
		"白銀黒狼『メティス』EX" => "2735",
		"純麗斧『ティアレア』" => "2736",
		"星乃瞬『レイセイ』EX" => "2737",
		"梨園の住人『神十郎』" => "2738",
		"朱雀の策士『スナフ』EX" => "2739",
		"聖騎士『リヴァーレⅢ』" => "2760",
		"黒戦士『フランシス』" => "2761",
		"戦乙女『カサンドラ』" => "2762",
		"人造賢者『グランヴェリオン』" => "2763",
		"遺恨の騎士『ランクロッツォ』" => "2765",
		"月の申し子『ミフィラー』EX" => "2766",
		"呪詛の列葬『スティラーヌ』" => "2767",
		"失敗兵『ナレヴィーズ』EX" => "2768",
		"憤怒の魔竜『ジズディガ』" => "2769",
		"怒りの武神『ディスタ』EX" => "2770",
		"憤慨の魔女『ファルナーレス』" => "2771",
		"黒猫『フェルアン』EX" => "2772",
		"導く瞳『フェリシア』" => "2785",
		"超獣偵士『デイビーブラウン』" => "2786",
		"真実の発露『ジャッカル』" => "2787",
		"探偵革命『蛍・ピーターソン』" => "2788",
		"時代の突破者『ジネン』" => "2831",
		"凍結女王『キャサリーン』" => "2849",
		"無限旋律『ジークフリート』" => "2850",
		"栄華求めし盟主『スパーダ』" => "2851",
		"エミリィ・セブンシープ" => "2853",
		"近衛木乃香" => "2854",
		"桜咲刹那" => "2855",
		"チャチャゼロ" => "2856",
		"神楽坂明日菜" => "2857",
		"春日美空" => "2858",
		"ネギ・スプリングフィールド" => "2859",
		"綾瀬夕映" => "2860",
		"木乃香＆刹那" => "2861",
		"アーニャ＆アスナ" => "2862",
		"エヴァンジェリン＆茶々丸" => "2863",
		"神機竜『アグスティン』" => "2879",
		"弾ける旋律『オルフェラ』" => "2880",
		"虐げる快感『メリィ・メア』" => "2881",
		"治癒の愛射" => "2882",
		"太陽王国の騎乗兵" => "2883",
		"戦場の祈り" => "2884",
		"太陽王国の重圧兵" => "2885",
		"救世主の信仰騎士" => "2886",
		"真教の戦道女" => "2887",
		"不死奮迅『剛毅』" => "2888",
		"冥姫の審判『フレジア』" => "2889",
		"骨肉腐敗『ジャージー』" => "2890",
		"妃と魔王" => "2891",
		"月公国の使用人" => "2892",
		"強制徴募" => "2893",
		"魔王の神官" => "2894",
		"腐竜" => "2895",
		"戦闘用魔法少女【灯火型】" => "2896",
		"真実の放浪者『ラーニ』" => "2897",
		"仏滅者『ハジャ』" => "2898",
		"土壌遊戯『ポルッカ』" => "2899",
		"全てを射抜く砲撃" => "2900",
		"傭兵王国の果敢な拳銃使い" => "2901",
		"巨大なる狂戦士" => "2902",
		"南蛮族の槍術使い" => "2903",
		"東方の連撃弓兵" => "2904",
		"南蛮族の奇襲兵" => "2905",
		"神滅機甲『ヴァルカイザーΩ』" => "2906",
		"学院長『マダム・ブランカ』" => "2907",
		"幻視者『サフィエ』" => "2908",
		"崩れ行く機甲" => "2909",
		"魔法王国の禁呪剣士" => "2910",
		"魔力の大樹" => "2911",
		"伝達する忍者" => "2912",
		"魔法王国の機甲兵" => "2913",
		"魔法王国の自動魔術使い" => "2914",
		"盗賊公爵『バレフォル』" => "2915",
		"邪滅聖人『カリオストロ』" => "2916",
		"言霊の術師『パンジェニア』" => "2917",
		"永劫狂『エキューナ』" => "2918",
		"失印者『ローズマリア』" => "2919",
		"忠実な実行者『スクワイア』" => "2920",
		"金色輝瞳『Ｑ・フランソワ』" => "2921",
		"対なる正義『ブラッドマン』" => "2922",
		"愛着人形『リビングベア』" => "2923",
		"血のやり取り" => "2924",
		"劇薬爆発" => "2925",
		"悲しみと絶望の暴食者" => "2926",
		"水鏡の炎術剣士" => "2927",
		"天馬の偵察兵" => "2928",
		"気楽な信奉剣士" => "2929",
		"漆黒の炎" => "2930",
		"時間逆行" => "2931",
		"水辺の放浪死体" => "2932",
		"真教の魔道僧侶" => "2933",
		"旋風の案内人" => "2934",
		"奇跡を操る晶騎士" => "2935",
		"黒衣の暗躍騎士" => "2936",
		"火の盾" => "2937",
		"魂魄吸収" => "2938",
		"振う盤剣の歌い手" => "2940",
		"新緑の戦歌姫" => "2941",
		"歌声の担い手" => "2942",
		"密室の電音支配者" => "2943",
		"弾ける音祭" => "2944",
		"狂響の駆逐者" => "2945",
		"ウィルス・ホルダー" => "2946",
		"一旋の戦乙女" => "2947",
		"嬋媛なる歌魔" => "2948",
		"水面に伝わる羽音" => "2949",
		"次元を超えて響く歌声" => "2950",
		"竜笛の姫君" => "2951",
		"望遠の拡声者" => "2952",
		"残奏に漂う希望歌" => "2953",
		"響歌の転校生" => "2954",
	}

	def plugin_contents(param, vars)
		return %Q!<div><a href="#{get_link(param)}">#{param}</a></div>!
	end

	def plugin_contents_inline(param, vars)
		return %Q!<a href="#{get_link(param)}">#{param}</a>!
	end

	def get_link(name)
		if NAME2ID.has_key?(name) then
			return "https://login.alteil.jp/al2CardDB/detail.php?id=#{NAME2ID[name]}"
		else
			raise FormatPluginWarning.new(
				"ユニット名指定ミス(ユニット名 = #{name})",
				"ユニット名に対応するユニットＩＤがありませんでした(ユニット名 = #{name})。")
		end
	end

end
