# coding: UTF-8

require 'plugin/weblog/lib/standard_command'

#=はてなダイアリーのためのブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_post.rb 431 2011-12-13 13:07:43Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryPost_WeblogPlugin < StandardCommand_WeblogPlugin

	def header_alias
		return {}
	end

	def post(original_content, header, content, contents, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#post ... header = #{header.to_s}")

		client = @parent.client
		formatter = @parent.formatter

		before(client, header, content, attachments)

		entry_content = formatter.preformat(
			content,
			original_content,
			attachments != nil && !attachments.empty?)

		header = @parent.mail_parser.get_alias_header(header, M2W_HATENA_DIARY_POST_HEADER_ALIAS)

		# ブログ記事を投稿する
		begin
			M2W_LOGGER.debug("Start  AtomPub.create_entry ... header = #{header.to_s}")
			new_entry = Atom::Entry.new(
				:title => header['title'].encode('BINARY', 'BINARY'),
				:content => entry_content.encode('BINARY', 'BINARY'))
			M2W_LOGGER.debug("entry = #{new_entry.to_s}")
			entry_uri = client.create_entry(@parent.entry_collection_uri, new_entry)
			postid = get_postid(entry_uri)
			@report[:original_content] = original_content
			@report[:postid] = postid
			@report[:attachment_urls] = {}
			@report[:thumbnail_urls] = {}
			M2W_LOGGER.debug("Finish AtomPub.create_entry ... entry_uri = #{entry_uri}, postid = #{postid}")
		rescue => e
			M2W_LOGGER.error("ブログ記事の投稿に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事投稿エラー(メッセージ = #{e.message})",
				"ブログ記事の投稿に失敗しました(メッセージ = #{e.message})。"))
		end

		after(client, header, content, attachments, entry_uri)

		M2W_LOGGER.debug("Finish #{self.class.name}#post")
		return true
	end

	def before(client, header, content, attachments)
	end

	def after(client, header, content, attachments, entry_uri)
	end

	def get_postid(entry_uri)
		if %r!/(([0-9]+/)?[0-9]+)$! =~ entry_uri then
			return $1
		else
			return nil
		end
	end

end
