# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事削除コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete.rb 771 2012-07-10 02:55:44Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Delete_CommandPlugin < StandardCommand

	def parse_mail_content
		content = @mail_parser.escaped_prefix_content(@mail.content, 'postid\.')
		(header, content, contents) = @mail_parser.parse_content(content, header_alias())
		return Mail2WeblogRequest.new(@mail, header, content, contents)
	end

	def run_before_parsing
		if @weblog != nil then
			@delete_plugin = @weblog.get_delete_plugin
		end
	end

	def header_alias()
		result = {}

		if @delete_plugin != nil then
			result = result.merge(@delete_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(request)
		@report = {}

		if @mail_sender != nil && @delete_plugin != nil then
			result = @delete_plugin.delete(request)
			@report = @delete_plugin.report.clone
			@report[:errors] = @delete_plugin.errors
			@report[:warnings] = @delete_plugin.warnings

			if result then
send_content = <<"END_CONTENT"
postid.#{@report[:postid]}

ブログ記事の削除に成功しました。
#{make_exception_contents(@delete_plugin.errors, @delete_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("deleted", @param, {}, send_content, @mail.from_address, [])
			else
send_content = <<"END_CONTENT"
ブログ記事の削除に失敗しました。
#{make_exception_contents(@delete_plugin.errors, @delete_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("error", @param, {}, send_content, @mail.from_address, [])
			end

			return result
		end

		return false
	end

end
