# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事簡易投稿コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: simple_post.rb 751 2012-06-27 07:11:31Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class SimplePost_CommandPlugin < StandardCommand

	def parse_mail_content
		header = nil
		content = nil
		html_header = nil
		html_content = nil

		simple_header = nil
		if @mail.has_content then
			(header, content, contents) = @mail_parser.parse_content(@mail.content, header_alias(), Mail2WeblogMailParserPlainTextType.new)
		end

		if @mail.has_html_content then
			(html_header, html_content, html_contents) = @mail_parser.parse_content(@mail.html_content, header_alias(), Mail2WeblogMailParserHtmlTextType.new)
		end

		real_header = header != nil ? header : html_header
		title = real_header.has_key?('tit') ? real_header['tit'] : @mail.subject
		real_header.delete('title')
		simple_header = {'tit' => title}
		simple_header.merge!(real_header)
		mail = __normalize_mail(@mail, simple_header, content, html_content)
		simple_header['title'] = title

		return Mail2WeblogRequest.new(
			mail,
			simple_header,
			content,
			contents,
			@mail.attachments,
			html_content,
			html_contents,
			@mail.related_attachments)
	end

	def run_before_parsing
		if @weblog != nil then
			@post_plugin = @weblog.get_post_plugin
		end
	end

	def header_alias()
		result = {}

		if @post_plugin != nil then
			result = result.merge(@post_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(request)
		@report = {}

		if @post_plugin != nil then
			result = @post_plugin.post(request, @param)
			@report = @post_plugin.report.clone
			@report[:errors] = @post_plugin.errors
			@report[:warnings] = @post_plugin.warnings

			(command, blogid) = @mail_parser.parse_subject(@mail.escaped_prefix_subject)
			if result then
send_content = <<"END_CONTENT"
ブログ記事の投稿に成功しました。

投稿記事のタイトル: #{@report[:title]}
#{make_exception_contents(@post_plugin.errors, @post_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("get", blogid, {"postid" => @report[:postid]}, send_content, @mail.from_address, [])
			else
send_content = <<"END_CONTENT"
ブログ記事の投稿に失敗しました。
#{make_exception_contents(@post_plugin.errors, @post_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("error", blogid, {}, send_content, @mail.from_address, [])
			end
		end

		return result

		return false
	end

	def __normalize_mail(mail, header, content, html_content)
		simple_content = content != nil ? @mail_sender.make_content(header, content, 'wiki') : nil
		simple_html_content = html_content != nil ? @mail_sender.make_content(header, html_content, 'html') : nil
		return Mail.new(mail.subject, nil, nil, simple_content, nil, simple_html_content)
	end

end
