# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_mail_sender'
require 'mailutils/mail_processor'

#=Mail2WeblogMailSender のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_m2w_mail_sender.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2WeblogMailParser < MiniTest::Unit::TestCase

	def setup
		@sender = Mail2WeblogMailSender.new(
			M2W_SMTP_SERVER_ADDRESS,
			M2W_SMTP_SERVER_PORT,
			M2W_SMTP_SECURITY_TYPE,
			M2W_SMTP_SERVER_USER,
			M2W_SMTP_SERVER_PASSWORD,
			M2W_POP3_BEFORE_SMTP_SERVER_ADDRESS,
			M2W_POP3_BEFORE_SMTP_SERVER_PORT,
			M2W_POP3_BEFORE_SMTP_SERVER_USER,
			M2W_POP3_BEFORE_SMTP_SERVER_PASSWORD,
			M2W_SUBJECT_HEADER,
			M2W_SUBJECT_SEPARATOR,
			MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))
	end

	def test_make_title
		assert_equal 'm.post', @sender.make_title('post')
		assert_equal 'm.post.1', @sender.make_title('post', "1")
	end

	def test_make_content
content = <<"END_CONTENT"
テスト
END_CONTENT
		assert_equal content.chomp, @sender.make_content(nil, 'テスト')

content = <<"END_CONTENT"
a.value1

テスト
END_CONTENT
		assert_equal content.chomp, @sender.make_content({'a' => 'value1'}, 'テスト')

content = <<"END_CONTENT"
a.value1
b.value2

テスト
END_CONTENT
		assert_equal content.chomp, @sender.make_content(['a', 'value1', 'b', 'value2'], 'テスト')
	end

end
