# coding: UTF-8

#=Seesaa ブログの全ての添付ファイル用ディレクトリを削除するためのスクリプトです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete_dirs.rb 761 2012-07-03 23:32:29Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../lib/")

require 'mechanize'
require 'optparse'
require 'thread_pool'

# 引数を解析する
# デフォルト値を設定する
config = {}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-u USERNAME', '--username USERNAME', '[必須]ログインユーザ名を指定する。') do |username|
		config['username'] = username
	end
	opts.on('-p PASSWORD', '--password PASSWORD', '[必須]パスワードを指定する。') do |password|
		config['password'] = password
	end
	opts.on('-b BLOGNAME', '--blogname BLOGNAME', '[必須]ブログ名を指定する。') do |blogname|
		config['blogname'] = %r!#{blogname}!
	end

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['username', 'password', 'blogname']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

thread_pool = ThreadPool.new(5)

agent = Mechanize.new do |agent|
	agent.user_agent_alias = 'Mac Safari'
	agent.verify_mode = OpenSSL::SSL::VERIFY_NONE
end

agent.get('http://blog.seesaa.jp/') do |page|
	login_page = agent.click(page.link_with(:text => 'ログイン'))

	puts "=== moved to login form."

	my_page = login_page.form_with(:action => 'auth') do |form|
		form.email = config['username']
		form.password = config['password']
	end.submit

	puts "=== logined"

	blog_page = agent.click(my_page.link_with(:text => config['blogname']))

	puts "=== moved to the #{config['blogname']} blog page."

	filemanager_page = agent.click(blog_page.link_with(:text => 'ファイルマネージャ'))

	puts "=== moved to the file manager."

	class DirDeleter

		def initialize(filemanager_page, deletedir_option)
			@filemanager_page = filemanager_page
			@deletedir_option = deletedir_option
		end

		def dir_option
			return @deletedir_option
		end

		def dir_level
			return @deletedir_option.value.count("/")
		end

		def run
			deletedir_page = @filemanager_page.form_with(:name => 'del') do |form|
				form.field_with(:name => 'upload__del_dirname').value = @deletedir_option
			end.submit

			puts "=== selected the directory ... #{@deletedir_option}"

			deletedir_page.form_with(:action => 'input') do |form|
			end.submit

			puts "=== deleted ... #{@deletedir_option}"
		end

	end

	dir_options = nil
	filemanager_page.form_with(:name => 'regist_form') do |form|
		select_field = form.field_with(:name => 'upload__del_dirname')
		if select_field == nil then
			puts "=== no target"
			exit
		end
		dir_options = select_field.options
	end

	mutex = Mutex.new

	dir_deleters = []
	dir_level = nil
	dir_last_level = nil

	while true
		mutex.lock
		if dir_options.size == 0 then
			mutex.unlock
			break
		else
			dir_deleters.push(dir_deleter = DirDeleter.new(filemanager_page, dir_options.pop))
			dir_last_level = dir_level
			dir_level = dir_deleter.dir_level
		end
		mutex.unlock

		if dir_last_level != nil && dir_level < dir_last_level then
			puts "=== joining ... #{dir_deleter.dir_option}"
			thread_pool.join
			puts "=== joined  ... #{dir_deleter.dir_option}"
		end

		thread_pool.run do
			mutex.synchronize do
				dir_deleter = dir_deleters.shift
			end
			dir_deleter.run
		end
	end

	thread_pool.join
end

puts "=== finished"
