# coding: UTF-8

#=Seesaa ブログの全ての添付ファイルを削除するためのスクリプトです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete_files.rb 762 2012-07-03 23:49:31Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../lib/")

require 'mechanize'
require 'optparse'

# 引数を解析する
# デフォルト値を設定する
config = {}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-u USERNAME', '--username USERNAME', '[必須]ログインユーザ名を指定する。') do |username|
		config['username'] = username
	end
	opts.on('-p PASSWORD', '--password PASSWORD', '[必須]パスワードを指定する。') do |password|
		config['password'] = password
	end
	opts.on('-b BLOGNAME', '--blogname BLOGNAME', '[必須]ブログ名を指定する。') do |blogname|
		config['blogname'] = %r!#{blogname}!
	end

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['username', 'password', 'blogname']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

agent = Mechanize.new do |agent|
	agent.user_agent_alias = 'Mac Safari'
	agent.verify_mode = OpenSSL::SSL::VERIFY_NONE
end

agent.get('http://blog.seesaa.jp/') do |page|
	login_page = agent.click(page.link_with(:text => 'ログイン'))

	puts "=== moved to login form."

	my_page = login_page.form_with(:action => 'auth') do |form|
		form.email = config['username']
		form.password = config['password']
	end.submit

	puts "=== logined"

	blog_page = agent.click(my_page.link_with(:text => config['blogname']))

	puts "=== moved to the mail2weblog blog page."

	filemanager_page = agent.click(blog_page.link_with(:text => 'ファイルマネージャ'))

	puts "=== moved to the file manager."

	while true
		delete_count = 0
		deletefile_page = filemanager_page.form_with(:name => 'myform_delete') do |form|
			form.checkboxes_with(:name => %r!^delete!).each do |field|
			  field.check
				delete_count = delete_count + 1
			end
		end.submit

		puts "=== checked the file"

		if delete_count == 0 then
			break
		end

		filemanager_page = deletefile_page.form_with(:action => 'input') do |form|
		end.submit

		puts "=== deleted ... #{delete_count}"
	end
end

puts "=== finished"
