# coding: UTF-8

#=mail2weblog の標準のレスポンス形式を定義する。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_response.rb 864 2012-10-23 22:36:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogResponse

	attr_accessor :success
	attr_reader :notices
	attr_reader :errors
	attr_reader :warnings

	def initialize
		@success = false
		@report = {}
		@notices = []
		@errors = []
		@warnings = []
	end

	def [](key)
		return @report[key]
	end

	def []=(key, value)
		@report[key] = value
	end

	def each(&block)
		if block nil
			@report.each do |key, value|
				block.call(key, value)
			end
		end
	end

end

class Mail2WeblogResponseNotice

	attr_reader :destination
	attr_reader :format
	attr_reader :type
	attr_reader :param
	attr_reader :header
	attr_reader :content
	attr_reader :contents
	attr_reader :attachments
	attr_reader :related_attachments

	def initialize(args)
		@destination = args[:destination] || nil
		@format = args[:format] || "plain"
		@type = args[:type] || nil
		@param = args[:param] || nil
		@header = args[:header] || {}
		@content = args[:content] || nil
		@attachments = args[:attachments] || []
		@related_attachments = args[:related_attachments] || []
	end

end
