# coding: UTF-8

require 'mailutils/mail_encoder'

#=単純なメールエンコーダーです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: simple_mail_encoder.rb 833 2012-10-02 16:55:46Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class SimpleMailEncoder < MailEncoder

	attr_writer :logger

	def initialize(to_encoding, logger = nil)
		@to_encoding = to_encoding
		@logger = logger
	end

	def encode(content, from_encoding)
		begin
			if from_encoding != nil then
				return content.encode(@to_encoding, from_encoding)
			else
				return content.encode(@to_encoding)
			end
		rescue => e
			@logger.error(e) if @logger
			if RUBY_VERSION < '1.9.0' then
				return content
			else
				return content.encode(@to_encoding, from_encoding, :invalid => :replace, :undef => :replace)
			end
		end
	end

end
