#!/usr/bin/ruby
# coding: UTF-8

#=mail2weblog のエントリーポイント
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w.rb 844 2012-10-19 21:52:57Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(File.expand_path(__FILE__))

# LOAD_PATH に必要なフォルダを追加する
$:.unshift(M2W_ROOT_PATH + "/")
$:.unshift(M2W_ROOT_PATH + "/lib")

require 'm2w_configurator'
require 'm2w_runner'

begin
	runner = Mail2WeblogRunner.new()

	if M2W_SYSTEM_LOCKFILE != nil then
		lockfile = File.open(M2W_ROOT_PATH + "/" + M2W_SYSTEM_LOCKFILE, 'w')
		lockfile.flock(File::LOCK_EX)
	end

	runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

	if M2W_SYSTEM_LOCKFILE != nil then
		lockfile.close
	end
rescue Mail2WeblogTimeout => tout
	M2W_LOGGER.info(tout.message)
	puts "Succeeded ... timeout"
	exit(0)
rescue => e
	M2W_LOGGER.error(e)
	puts "Failed ... #{e.message}"
	exit(1)
end

puts "Succeeded ... normal"
exit(0)
