# coding: UTF-8

require 'm2w_request'
require 'm2w_mail_parser_html_text_type'
require 'm2w_mail_parser_plain_text_type'

#=コマンドアダプタープラグイン（メール用）の標準実装
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_command_adapter4mail.rb 874 2012-10-31 07:01:35Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Standard_CommandAdapterPlugin4Mail

	attr_writer :mail_parser
	attr_writer :plugin_manager
	attr_writer :logger

	def create_request(command, mail)
		subject_parsed_result = @mail_parser.parse_subject(mail.escaped_prefix_subject)
		param = subject_parsed_result ? subject_parsed_result[1] : nil

		header = content = contents = nil
		html_header = html_content = html_contents = nil

		if mail.has_content then
			(header, content, contents) = @mail_parser.parse_content(mail.content, command.header_alias(), Mail2WeblogMailParserPlainTextType.new)
			param = header['blogid'] if header.has_key?('blogid')
		end

		if mail.has_html_content then
			(html_header, html_content, html_contents) = @mail_parser.parse_content(mail.html_content, command.header_alias(), Mail2WeblogMailParserHtmlTextType.new)
			param = html_header['blogid'] if html_header.has_key?('blogid')
		end

		request_header = header != nil ? header : html_header
		request_format = format(request_header, mail)
		return Mail2WeblogRequest.new(
			:source => mail.from_address.address,
			:format => request_format,
			:param => param,
			:original_content => __original_content(request_format, mail),
			:header => request_header,
			:content => __content(request_format, content, html_content),
			:contents => __contents(request_format, contents, html_contents),
			:attachments => mail.attachments,
			:related_attachments => mail.related_attachments)
	end

	def make_exception_contents(response)
		result = ""

		if response.errors.length > 0 then
			result << "\n= エラー =\n\n"
			response.errors.each do |error|
				result << "*#{error.message}\n"
			end
		end

		if response.warnings.length > 0 then
			result << "\n= 警告 =\n\n"
			response.warnings.each do |warning|
				result << "*#{warning.message}\n"
			end
		end

		return result
	end

	def format(header, mail)
		setter_name_format_mode = @plugin_manager.setter_name('format_mode', 'mode')

		format_mode = nil
		if setter_name_format_mode != nil && header[setter_name_format_mode] != nil then
			format_mode = header[setter_name_format_mode]
		else
			format_mode = @plugin_manager.default_format_mode
		end

		if format_mode == 'html' then
			return mail.has_html_content ? 'html' : 'htmlplain'
		else
			return format_mode
		end
	end

	def __original_content(format, mail)
		case format
		when 'wiki', 'htmlplain'
			return mail.content
		when 'html'
			return mail.html_content
		else
			raise Mail2WeblogException.new(
				"不明な書式モードエラー(フォーマットモード = #{format})",
				"不明な書式モードを指定しました（フォーマットモード = #{format}）。")
		end
	end

	def __content(format, content, html_content)
		case format
		when 'wiki', 'htmlplain'
			return content
		when 'html'
			return html_content
		else
			raise Mail2WeblogException.new(
				"不明な書式モードエラー(フォーマットモード = #{format})",
				"不明な書式モードを指定しました（フォーマットモード = #{format}）。")
		end
	end

	def __contents(format, contents, html_contents)
		case format
		when 'wiki', 'htmlplain'
			return contents
		when 'html'
			return html_contents
		else
			raise Mail2WeblogException.new(
				"不明な書式モードエラー(フォーマットモード = #{mode(request)})",
				"不明な書式モードを指定しました（フォーマットモード = #{mode(request)}）。")
		end
	end

end
