# coding: UTF-8

require 'plugin/format/lib/format_plugin_utils'
require 'plugin/format/lib/format_plugin_warning'

require 'cgi'

# =添付画像を貼り付ける書式プラグイン
#
# 詳細な仕様については以下のページを参照してください。
#
# * http://sourceforge.jp/projects/mail2weblog/wiki/howto%2Fuse%2Fformat%2Fimg
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: img.rb 801 2012-08-04 13:31:45Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Img_FormatPlugin
	include FormatPluginUtils

	OPTION_ALIAS = {
		'thumb' => 'thumbnail',
		'tmpname' => 'template_name',
		'tmpname_nt' => 'template_name_no_thumbnail',
		'cw' => 'condition_width',
		'ch' => 'condition_height',
		's' => 'scale',
		'w' => 'width',
		'h' => 'height',
		'k' => 'keep',
	}
	OPTION_DEFAULT_VALUE = {
		'template_name' => 'simple',
		'template_simple' => '<a ${attachment_href}><img ${thumbnail_src} ${alt_a} /></a>',
		'template_hs.b' => '<a ${attachment_href} class="highslide" onclick="return hs.expand(this)"><img ${thumbnail_src} ${alt_a} /></a>',
		'template_hs.bc' => '<a ${attachment_href} class="highslide" onclick="return hs.expand(this)"><img ${thumbnail_src} ${alt_a} /></a><div class="highslide-caption"><p>${caption_v}</p></div>',
	}

	def plugin_preset(param, vars)
		param = __get_param(param)

		(params, option, content) = get_format_plugin_parameter(param, vars, 1, OPTION_ALIAS, OPTION_DEFAULT_VALUE)

		if option.has_key?('thumbnail') then
			attachment_index = params[0]

			thumbnail_setting_keys = [
				'condition_width',
				'condition_height',
				'scale',
				'width',
				'height',
				'keep'
			]

			thumbnail_setting = {}

			thumbnail_setting_keys.each do |key|
				thumbnail_setting[key] = option[key] if option.has_key?(key)
			end

			return {
				M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => {
					M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME => {
						attachment_index => thumbnail_setting
					}
				}
			}
		else
			return {}
		end
	end

	def plugin_preset_inline(param, vars)
		plugin_preset(param, vars)
	end

	def plugin_contents(param, vars)
		param = __get_param(param)

		(params, option, content) = get_format_plugin_parameter(param, vars, 1, OPTION_ALIAS, OPTION_DEFAULT_VALUE)
		attachment_url = __get_url(params[0], vars, :attachment_urls)
		thumbnail_url = __get_url(params[0], vars, :thumbnail_urls)

		if attachment_url != nil then
			return %Q!<div>#{__get_img_tag(params[0], option, attachment_url, thumbnail_url)}</div>!
		else
			raise FormatPluginWarning.new(
				"画像番号指定ミス(画像番号 = #{params[0]})",
				"画像番号に対応する添付ファイルがありませんでした(画像番号 = #{params[0]})。")
		end
	end

	def plugin_contents_inline(param, vars)
		param = __get_param(param)

		(params, option, content) = get_format_plugin_parameter(param, vars, 1, OPTION_ALIAS, OPTION_DEFAULT_VALUE)
		attachment_url = __get_url(params[0], vars, :attachment_urls)
		thumbnail_url = __get_url(params[0], vars, :thumbnail_urls)

		if attachment_url != nil then
			return %Q!#{__get_img_tag(params[0], option, attachment_url, thumbnail_url)}!
		else
			raise FormatPluginWarning.new(
				"画像番号指定ミス(画像番号 = #{params[0]})",
				"画像番号に対応する添付ファイルがありませんでした(画像番号 = #{params[0]})。")
		end
	end

	def __get_param(param)
		if param == nil then
			return '1'
		elsif param =~ %r!^(|/.*)$! then
			return "1#{$1}"
		end

		return param
	end

	def __get_url(param, vars, key)
		attachment_urls = vars[key]

		if attachment_urls != nil then
			if /^([0-9]*)$/ =~ param then
				index = param.to_i
				if attachment_urls.has_key?(index) then
					return attachment_urls[index]
				end
			else
				return nil
			end
		end
	end

	def __get_img_tag(index, option, attachment_url, thumbnail_url)
		template_name = __get_template_name(index, option, thumbnail_url)

		if template_name == nil then
			return %Q!<img src="#{attachment_url}" />!
		else
			template = option[template_name]
			if template != nil then
				vars = {}
				option.each do |key, value|
					if value != nil then
						vars["${#{key}_v}"] = "#{CGI.escapeHTML(value)}"
						vars["${#{key}_a}"] = %Q!#{key}="#{CGI.escapeHTML(value)}"!
					end
					if attachment_url != nil then
						vars["${attachment_href}"] = %Q!href="#{CGI.escapeHTML(attachment_url)}"!
						vars["${attachment_src}"] = %Q!src="#{CGI.escapeHTML(attachment_url)}"!
						vars["${attachment_url_v}"] = "#{CGI.escapeHTML(attachment_url)}"
					end
					if thumbnail_url != nil then
						vars["${thumbnail_href}"] = %Q!href="#{CGI.escapeHTML(thumbnail_url)}"!
						vars["${thumbnail_src}"] = %Q!src="#{CGI.escapeHTML(thumbnail_url)}"!
						vars["${thumbnail_url_v}"] = "#{CGI.escapeHTML(thumbnail_url)}"
					end
				end

				return __apply_template(template, vars)
			else
				raise FormatPluginWarning.new(
					%Q!画像テンプレート指定ミス(画像番号 = #{index}, テンプレート名 = #{option["template_#{option['template_name']}"]})!,
					%Q!指定した画像テンプレートがありませんでした(画像番号 = #{index}, テンプレート名 = #{option["template_#{option['template_name']}"]})。!)
			end
		end
	end

	def __get_template_name(index, option, thumbnail_url)
		if thumbnail_url == nil then
			return option['template_name_no_thumbnail'] == nil ? nil : "template_#{option['template_name_no_thumbnail']}"
		else
			return option['template_name'] == nil ? nil : "template_#{option['template_name']}"
		end
	end

	def __apply_template(template, vars)
		result = ""

		while /^(.*?)(\$\{[0-9a-zA-Z_]+\})(.*)$/ =~ template
			left = $1
			attr_name = $2
			template = $3

			result << left
			if vars[attr_name] != nil then
				result << vars[attr_name]
			end
		end

		result << template

		return result
	end

end
