# coding: UTF-8

if $0 == __FILE__ then
	begin
		require 'rubygems'
	rescue LoadError
	end

	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")

	require 'minitest/autorun'
end

require 'conf/01_system/ruby_version_absorber'

#=RubyVersionAbsorber のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_ruby_version_absorber.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestRubyVersionAbsorber < MiniTest::Unit::TestCase

	# エンコード取得のテスト

	def test_encoding_utf8
		encoding = "UTF-8"
		assert_equal encoding, get_text(encoding).encoding.to_s
	end

	def test_encoding_sjis
		encoding = "Shift_JIS"
		assert_equal encoding, get_text(encoding).encoding.to_s
	end

	def test_encoding_eucjp
		encoding = "EUC-JP"
		assert_equal encoding, get_text(encoding).encoding.to_s
	end

	# 相互エンコード変換のテスト

	def test_utf8_to_sjis
		to = "Shift_JIS"
		assert_equal get_text(to), get_text("UTF-8").encode(to)
	end

	def test_utf8_to_eucjp
		to = "EUC-JP"
		assert_equal get_text(to), get_text("UTF-8").encode(to)
	end

	def test_sjis_to_utf8
		to = "UTF-8"
		assert_equal get_text(to), get_text("Shift_JIS").encode(to)
	end

	def test_eucjp_to_utf8
		to = "EUC-JP"
		assert_equal get_text(to), get_text("Shift_JIS").encode(to)
	end

	def test_utf8_to_eucjp
		to = "UTF-8"
		assert_equal get_text("UTF-8"), get_text("EUC-JP").encode("UTF-8")
	end

	def test_sjis_to_eucjp
		to = "Shift_JIS"
		assert_equal get_text(to), get_text("EUC-JP").encode(to)
	end

	# 同一エンコード変換のテスト

	def test_utf8_to_utf8
		to = "UTF-8"
		assert_equal get_text(to), get_text("UTF-8").encode(to)
	end

	def test_sjis_to_sjis
		to = "Shift_JIS"
		assert_equal get_text(to), get_text("Shift_JIS").encode(to)
	end

	def test_utf8_to_utf8
		to = "EUC-JP"
		assert_equal get_text(to), get_text("EUC-JP").encode(to)
	end

	def test_basename
		assert_equal 'ハート.jpg', File.basename('ハート.jpg')
		assert_equal 'ハート', File.basename('ハート.jpg', '.jpg')
		assert_equal 'ハート', File.basename('ハート.jpg', '.*')

		assert_equal 'ハート.jpg', File.basename('abc/ハート.jpg')
		assert_equal 'ハート', File.basename('abc/ハート.jpg', '.jpg')
		assert_equal 'ハート', File.basename('abc/ハート.jpg', '.*')

		assert_equal 'ハート.jpg', File.basename('abc/def/ハート.jpg')
		assert_equal 'ハート', File.basename('abc/def/ハート.jpg', '.jpg')
		assert_equal 'ハート', File.basename('abc/def/ハート.jpg', '.*')
	end

	def test_extname
		assert_equal '.jpg', File.extname('ハート.jpg')
		assert_equal '.jpg', File.extname('abc/ハート.jpg')
		assert_equal '.jpg', File.extname('abc/def/ハート.jpg')
	end

	def get_text(encoding)
		File.open("#{File.dirname(File.expand_path(__FILE__))}/data/#{encoding}.txt") do |file|
			return file.gets.encode(encoding, encoding)
		end
	end

end
