# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'uri'

require 'blogger/blogger'

require "#{File.dirname(File.expand_path(__FILE__))}/../m2w/conf/setting"
require "#{File.dirname(File.expand_path(__FILE__))}/conf/setting"

#=blogger API のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_blogger.rb 889 2012-12-02 17:27:31Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestBlogger < MiniTest::Unit::TestCase

	if M2W4TEST_REAL && M2W4TEST_BLOGGER_BLOGS != nil then
		def test_get_users_blogs
			uri = URI.parse(M2W4TEST_WEBLOG_ENDPOINT)
			client = XMLRPC::Client.new(uri.host, uri.path)
			client.set_parser(M2W4TEST_BLOGGER_XMLRPC_PARSER) if M2W4TEST_BLOGGER_XMLRPC_PARSER != nil
			blogger = Blogger.new(client, M2W4TEST_WEBLOG_USERNAME, M2W4TEST_WEBLOG_PASSWORD, M2W_SYSTEM_INNER_ENCODING)
			result = blogger.get_users_blogs()
			M2W4TEST_BLOGGER_BLOGS.keys.each_with_index do |blogid, i|
				expected = M2W4TEST_BLOGGER_BLOGS[blogid]
				assert result[i] != nil, result.to_s
				assert_equal expected[0], result[i].blogid
				assert_equal expected[1], result[i].url
				assert_equal expected[2], result[i].blog_name
			end
		end
	end

end
